% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{csv_to_population}
\alias{csv_to_population}
\title{Function used to convert your genetic algorithm results that are stored into 
a .csv file to a Data structure that can be used by the clustering algorithm}
\usage{
csv_to_population(ATC_name, filename, sep = ";")
}
\arguments{
\item{ATC_name}{the ATC_name column of the ATC tree}

\item{filename}{Name of the file where the results are located}

\item{sep}{the separator to use when opening the csv file (';' by default)}
}
\value{
An R List that can be used by other algorithms (e.g. clustering algorithm)
}
\description{
Function used to convert your genetic algorithm results that are stored into 
a .csv file to a Data structure that can be used by the clustering algorithm
}
\examples{
\donttest{
  data("ATC_Tree_UpperBound_2024")
  genetic_results = csv_to_population(ATC_Tree_UpperBound_2024$Name,
                    "path/to/output.csv")
}
}
