% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dynamic.sign}
\alias{plot.dynamic.sign}
\title{Visualization for Dynamic Signed Networks}
\usage{
\method{plot}{dynamic.sign}(
  x,
  col_pos = "#008000",
  col_neg = "#E3000F",
  neg.lty = 1,
  inv_weights = TRUE,
  time = NULL,
  titles = NULL,
  fix.pos = TRUE,
  ...
)
}
\arguments{
\item{x}{A signed network object of class \code{dynamic.sign}.}

\item{col_pos}{Color for positive edges. Default is 'green3'.}

\item{col_neg}{Color for negative edges. Default is 'red3'.}

\item{neg.lty}{Line type for negative edges. Default is "solid". Other options are "dotted" and "dashed".}

\item{inv_weights}{Logical. If TRUE, edge weights are inverted (1/weights) so positive edges pull nodes closer together. Default is TRUE.}

\item{time}{A vector of integers indicating which timepoints should be visualized. Defaults to all.}

\item{titles}{A character vector of names for the timepoints.}

\item{fix.pos}{Logical. If TRUE, the layout is fixed across timepoints based on the first timepoint. Default is TRUE.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
A list of plots, one for each selected timepoint.
}
\description{
\code{plot.dynamic.sign()} visualizes a dynamic signed network over multiple timepoints.
}
\section{Layout}{

Uses a force-directed graph layout based on stress majorization, implemented in the \code{graphlayouts} package
via \code{layout_with_stress()}. Similar to Kamada-Kawai, but generally faster and with better results.
}

