% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{threetrail-ergmTerm}
\alias{threetrail-ergmTerm}
\alias{InitErgmTerm.threetrail}
\alias{InitErgmTerm.threepath}
\alias{threepath-ergmTerm}
\title{Three-trails}
\usage{
# binary: threetrail(keep=NULL, levels=NULL)

# binary: threepath(keep=NULL, levels=NULL)
}
\arguments{
\item{keep}{deprecated}

\item{levels}{specify a subset of the four statistics for directed networks. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
For an undirected network, this term adds one statistic equal to the number
of 3-trails, where a 3-trail is defined as a trail of length three that
traverses three distinct edges.
Note that a 3-trail need not
include four distinct nodes; in particular, a triangle counts as three
3-trails. For a directed network, this term adds four statistics
(or some subset of these four),
one for each of the four distinct types of directed three-paths. If the
nodes of the path are written from left to right such that the middle edge
points to the right (R), then the four types are RRR, RRL, LRR, and LRL.
That is, an RRR 3-trail is of the form
\eqn{i\rightarrow j\rightarrow k\rightarrow l}{i-->j-->k-->l} , and RRL
3-trail is of the form
\eqn{i\rightarrow j\rightarrow k\leftarrow l}{i-->j-->k<--l} , etc.
Like in the undirected case, there is no requirement that the nodes be
distinct in a directed 3-trail. However, the three edges must all be
distinct. Thus, a mutual tie \eqn{i\leftrightarrow j}{i<-->j} does not
count as a 3-trail of the form
\eqn{i\rightarrow j\rightarrow i\leftarrow j}{i-->j-->i<--j} ; however,
in the subnetwork \eqn{i\leftrightarrow j \rightarrow k}{i<-->j-->k} ,
there are two directed 3-trails, one LRR
( \eqn{k\leftarrow j\rightarrow i\leftarrow j}{k<--j-->i-->j} )
and one RRR
( \eqn{j\rightarrow i\rightarrow j\leftarrow k}{k<--j-->i-->j} ).
}
\note{
The argument \code{keep} is retained for backwards compatibility and may be
removed in a future version. When both \code{keep} and \code{levels} are passed,
\code{levels} overrides \code{keep}. See \code{\link{nodal_attributes}}.

This term used to be (inaccurately) called \code{threepath} . That
name has been deprecated and may be removed in a future version.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "threetrail", "subsection")}
}
\concept{directed}
\concept{triad-related}
\concept{undirected}
