.evidence_table_2x2 <- function(x, scale, level) {
  if (!all(dim(x) == c(2, 2))) stop("Input must be a 2x2 table.")

  a <- x[1, 1]; b <- x[1, 2]
  c <- x[2, 1]; d <- x[2, 2]

  n1 <- a + b
  n2 <- c + d

  p1 <- a / n1
  p2 <- c / n2

  if (scale == "log_or") {
    est <- log((a * d) / (b * c))
    se <- sqrt(1 / a + 1 / b + 1 / c + 1 / d)
  } else if (scale == "risk_diff") {
    est <- p1 - p2
    se <- sqrt(p1 * (1 - p1) / n1 + p2 * (1 - p2) / n2)
  } else {
    est <- log(p1 / p2)
    se <- sqrt((1 - p1) / a + (1 - p2) / c)
  }

  z <- stats::qnorm((1 + level) / 2)
  interval <- c(est - z * se, est + z * se)

  ll0 <- stats::dbinom(a, n1, (a + c) / (n1 + n2), log = TRUE) +
         stats::dbinom(c, n2, (a + c) / (n1 + n2), log = TRUE)
  
  ll1 <- stats::dbinom(a, n1, p1, log = TRUE) +
         stats::dbinom(c, n2, p2, log = TRUE)

  log10_er <- (ll1 - ll0) / log(10)

  .evidence_result(
    estimate = est,
    interval = interval,
    interval_level = level,
    log10_er = log10_er,
    null = "equal proportions",
    alternative = "unequal proportions",
    model = "2x2 contingency table",
    call = match.call()
  )
}

