% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_return_level.R
\name{return_level_methods}
\alias{return_level_methods}
\alias{coef.return_level}
\alias{print.return_level}
\alias{vcov.return_level}
\alias{summary.return_level}
\alias{print.summary.return_level}
\alias{confint.return_level}
\title{Methods for objects of class \code{"return_level"}}
\usage{
\method{coef}{return_level}(object, ...)

\method{print}{return_level}(x, ...)

\method{vcov}{return_level}(object, ...)

\method{summary}{return_level}(object, digits = max(3, getOption("digits") - 3L), ...)

\method{print}{summary.return_level}(x, ...)

\method{confint}{return_level}(
  object,
  parm = 1:length(object),
  level = 0.95,
  profile = FALSE,
  mult = 2,
  faster = FALSE,
  epsilon = 1e-04,
  ...
)
}
\arguments{
\item{object, x}{An object inheriting from class \code{"return_level"}, a result
of a call to \code{\link{gev_return}}. \code{object} is a named numeric vector of MLEs of
return levels.

For \code{print.summary.return_level}, this is an object returned by the
function \code{summary.return_level}.}

\item{...}{Further arguments. Only used for \code{print.summary.return_level} to
pass arguments to \code{\link{print}}.}

\item{digits}{An integer. Passed to \code{\link{signif}} to round the
values in the summary.}

\item{parm}{A numeric vector. For which components, that is, which return
levels, in \code{object} we require a confidence interval.}

\item{level}{The confidence level required.  A numeric scalar in (0, 1).}

\item{profile}{A logical scalar. If \code{TRUE} then confidence intervals
based on a profile log-likelihood are returned.  If \code{FALSE} then intervals
based on approximate large sample normal theory, which are symmetric about
the MLE, are returned.}

\item{mult}{A positive numeric scalar. Controls the increment by which the
parameter of interest is increased/decreased when profiling above/below
its MLE. The increment is \code{mult * se / 100} where \code{se} is the estimated
standard error of the estimator of the return level. Decreasing \code{mult}
profiles at more points but will be slower.}

\item{faster}{A logical scalar. If \code{faster = TRUE} then the profiling of the
log-likelihood in search of a lower (upper) confidence limit is started at
the corresponding symmetric lower (upper) confidence limit.}

\item{epsilon}{Only relevant if \code{profile = TRUE}. A numeric vector of values
that determine the accuracy of the confidence limits. \code{epsilon} is
recycled to the length of the parameter vector \code{parm}.
\itemize{
\item If \code{epsilon[i] > 0} then this value is passed as the argument \code{epsilon}
to the \code{\link[itp:itp]{itp::itp}} function, which estimates the parameter values for
which the profile log-likelihood for parameter \code{i} drops to the value
that defines the confidence limits, once profiling has been successful
in finding an interval within which this value lies.
\item If \code{epsilon[i] < 0} monotonic cubic spline interpolation is used, which
will tend to be faster.
\item If \code{epsilon[i] = 0} then linear interpolation is used, which will be
faster still.
}}
}
\value{
\code{print.return_level} and \code{coef.return_level}: a numeric vector
containing the MLEs of return return levels.

\code{vcov.return_level}: a \code{length(object)} by \code{length(object)} matrix with
row and column names indicating the return periods of the return levels.
The estimated variance-covariance matrix for the return levels in
\code{object}. The diagonal elements give the estimated variances associated
with the individual return level estimates.

\code{summary.return_level}: an object containing the original function call
and a matrix of estimates of return levels and associated estimated
standard errors with row names indicating the respective return periods.
The object is printed by \code{\link{print.summary.return_level}}.

\code{print.summary.return_level}: the argument \code{x} is returned, invisibly.

\code{confint.return_level}: an object of class
\code{c("confint_return_level", "evmissing")}. A numeric matrix with 2 columns
giving the lower and upper confidence limits for each return level. These
columns are labelled as \code{(1-level)/2} and \code{1-(1-level)/2}, expressed as a
percentage, by default \verb{2.5\%} and \verb{97.5\%}. The row names indicate the
return levels.
If \code{profile = TRUE} then the returned object has extra attributes \code{crit},
\code{level} and \code{for_plot}. The latter is a named list of length  \code{parm} with
components named after the return periods. Each components is a 2-column
numeric matrix. The first column contains values of the return level and
the second column the corresponding values of the profile log-likelihood.
The profile log-likelihood is equal to the attribute \code{crit} at the limits
of the confidence interval. The attribute \code{level} is the input argument
\code{level}.
}
\description{
Methods for objects of class \code{"return_level"} returned from \code{\link{gev_return}}.
}
\details{
For \code{confint.return_level}, the default, \code{epsilon = -1}, should
work well enough in most circumstances, but to achieve a specific accuracy
set \code{epsilon} to be a small positive value, for example, \code{epsilon = 1e-4}.
}
\examples{
## Plymouth ozone data

# See ?gev_return for confidence intervals for return levels
fit <- gev_mle(PlymouthOzoneMaxima)
rl <- gev_return(fit, m = c(100, 200))
rl
vcov(rl)
summary(rl)
}
\seealso{
\code{\link{gev_mle}} and \code{\link{gev_return}}, for examples of the use of
\code{\link{confint.return_level}}.
}
