% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_contact}
\alias{send_contact}
\title{Send a WhatsApp contact (auto-generate wuid)}
\usage{
send_contact(client, number, contact, verbose = FALSE)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Recipient number (e.g., \code{"5581999990000"}).}

\item{contact}{Either:
\itemize{
\item a named list with fields \code{fullName}, \code{phoneNumber}, \code{organization},
\code{email}, \code{url}; or
\item a list of such lists (to send multiple contacts).
The \code{wuid} field will be auto-generated if missing.
}}

\item{verbose}{Logical; if \code{TRUE}, shows detailed logs.}
}
\value{
Parsed JSON response as list (see \code{\link[=.evo_post]{.evo_post()}} for details).
}
\description{
Sends one or more contacts following the Evolution API v2
format. Automatically generates the \code{wuid} field as
\verb{<digits>@s.whatsapp.net} from each contact's phone number
(or from \code{number} if not provided).
}
\examples{
\dontrun{
send_contact(client, "5581999990000",
  contact = list(
    fullName     = "Jane Doe",
    phoneNumber  = "+5581999990000",
    organization = "Company Ltd.",
    email = "jane@example.com",
    url   = "https://company.com"
  ))
}
}
