% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{tidy.FASSTER}
\alias{tidy.FASSTER}
\title{Extract coefficients from a FASSTER model}
\usage{
\method{tidy}{FASSTER}(x, ...)
}
\arguments{
\item{x}{An object containing a FASSTER model.}

\item{...}{Unused.}
}
\value{
A tibble with three columns:
\describe{
\item{term}{The name of each state variable in the model.}
\item{estimate}{The mean of the estimated initial state for each term.}
\item{std.error}{The standard deviation of the estimated initial state for each term.}
}
}
\description{
Obtains the mean and variance of the estimated initial states from a FASSTER
model. Values in the \code{estimate} column are contains the mean, and the
\code{std.error} column contains the standard deviation of the initial states.
}
