% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_config.R
\name{get_tuning_params_for_complexity}
\alias{get_tuning_params_for_complexity}
\title{Get Tuning Parameters for Complexity Level}
\usage{
get_tuning_params_for_complexity(
  algo,
  train_data,
  label,
  engine,
  complexity = "balanced"
)
}
\arguments{
\item{algo}{Character string specifying the algorithm name.}

\item{train_data}{Data frame containing the training data.}

\item{label}{Character string specifying the outcome variable name.}

\item{engine}{Character string specifying the engine.}

\item{complexity}{Character string specifying tuning complexity level.}
}
\value{
A list of tuning parameter ranges.
}
\description{
Returns algorithm-specific tuning parameter ranges adjusted for the
specified complexity level.
}
\details{
Parameter ranges are scaled based on the complexity level:
- \code{quick}: Narrower ranges (70% of standard), fewer discrete values
- \code{balanced}: Standard ranges (100%)
- \code{thorough}: Wider ranges (130% of standard)
- \code{exhaustive}: Very wide ranges (150% of standard)
}
