% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_register}
\alias{simulate_register}
\title{Simulate an example register}
\usage{
simulate_register(register, year = "", n = 1000)
}
\arguments{
\item{register}{Name of the register. Must be accepted by
\code{osdc::simulate_registers()}.}

\item{year}{Year suffixes for list element names (e.g., \code{"2020"},
\code{"1999_1"}, or \code{""} for no suffix).}

\item{n}{Number of rows per year.}
}
\value{
A named list of tibbles following the naming scheme
\verb{\{register\}\{year\}} or just \code{{register}} when year = "".
}
\description{
This is a helper function that simulates data using
\code{osdc::simulate_registers()}. It's used in vignettes and tests.
}
\examples{
simulate_register(register = "bef", year = c("1999", "2000"))
}
