% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.feistest}
\alias{summary.feistest}
\alias{print.summary.feistest}
\alias{summary.bsfeistest}
\alias{print.summary.bsfeistest}
\title{Summary for feistest and bsfeistest objects}
\usage{
\method{summary}{feistest}(object, ...)

\method{print}{summary.feistest}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{summary}{bsfeistest}(object, ...)

\method{print}{summary.bsfeistest}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)
}
\arguments{
\item{object}{an object of class "\code{feistest}" or "\code{bsfeistest}".}

\item{...}{further arguments.}

\item{x}{an object of class "\code{summary.feistest}" or "\code{summary.bsfeistest}".}

\item{digits}{number of digits for printed output.}

\item{width}{the maximum length of the lines in the printed output.}
}
\value{
An object of class "\code{summary.feistest}" or "\code{summary.bsfeistest}",
equal to the original input object (see \code{\link[feisr]{feistest}} and
\code{\link[feisr]{bsfeistest}}). The object is forwarded to print method.
}
\description{
The summary method for feistest and bsfeistest objects prints the results
of Artificial Regression Tests or Bootstrapped Hausman Tests for FEIS models.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry | exp,
                 data = mwp, id = "id")
ht <- feistest(feis.mod, robust = TRUE, type = "all")
summary(ht)

}
\seealso{
\code{\link[feisr]{feistest}}, \code{\link[feisr]{bsfeistest}}
}
