# Generated by extendr: Do not edit by hand

# nolint start

#
# This file was created with the following call:
#   .Call("wrap__make_fio_wrappers", use_symbols = TRUE, package_name = "fio")

#' @usage NULL
#' @useDynLib fio, .registration = TRUE
NULL

#' @description
#' Computes technical coefficients matrix.
#' 
#' @param intermediate_transactions
#' A \eqn{n x n} matrix of intermediate transactions.
#' @param total_production
#' A \eqn{1 x n} vector of total production.
#' 
#' @details
#' It computes the technical coefficients matrix, a \eqn{n x n} matrix known as `A` matrix which is the column-wise
#' ratio of intermediate transactions to total production \insertCite{leontief_economia_1983}{fio}.
#'
#' It takes a \eqn{n x n} matrix of intermediate transactions and a \eqn{1 x n} vector of total production,
#' and populates the `technical_coefficients_matrix` field with the result.
#'
#' Underlined Rust code uses Rayon crate to parallelize the computation. So there is no need to use future or
#' async/await to parallelize.
#' 
#' @return
#' A \eqn{n x n} matrix of technical coefficients, known as A matrix.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @examples
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' total_production <- matrix(c(100, 200, 300), 1, 3)
#' # instantiate iom object
#' my_iom <- fio::iom$new("test", intermediate_transactions, total_production)
#' # Calculate the technical coefficients
#' my_iom$compute_tech_coeff()
#' # show the technical coefficients
#' my_iom$technical_coefficients_matrix
#' 
#' @noRd
compute_tech_coeff <- function(intermediate_transactions, total_production) .Call(wrap__compute_tech_coeff, intermediate_transactions, total_production)

#' @description
#' Computes Leontief inverse matrix.
#' 
#' @param tech_coeff
#' A \eqn{n x n} matrix of technical coefficients.
#' 
#' @details
#' It computes the Leontief inverse matrix \insertCite{leontief_economia_1983}{fio}, which is the inverse of the
#' Leontief matrix. Defined as:
#' 
#' \deqn{L = I - A}
#' 
#' where I is the identity matrix and A is the technical coefficients matrix.
#' 
#' The Leontief inverse matrix is calculated by solving the following equation:
#' 
#' \deqn{L^{-1} = (I - A)^{-1}}
#' 
#' Since the Leontief matrix is a square matrix and the subtraction of the
#' technical coefficients matrix from the identity matrix guarantees that the
#' Leontief matrix is invertible, this function computes the Leontief inverse
#' matrix through LU decomposition.
#' 
#' @return
#' A \eqn{n x n} matrix of Leontief inverse.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @examples
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' total_production <- matrix(c(100, 200, 300), 1, 3)
#' # instantiate iom object
#' my_iom <- fio::iom$new("test", intermediate_transactions, total_production)
#' # Calculate the technical coefficients
#' my_iom$compute_tech_coeff()
#' # Calculate the Leontief inverse
#' my_iom$compute_leontief_inverse()
#' # show the Leontief inverse
#' my_iom$leontief_inverse_matrix
#' 
#' @noRd
compute_leontief_inverse <- function(tech_coeff) .Call(wrap__compute_leontief_inverse, tech_coeff)

#' Computes output multiplier.
#' @param leontief_inverse_matrix The open model Leontief inverse matrix.
#' @return A 1xn vector of type I output multipliers.
#' @noRd
compute_multiplier_output <- function(leontief_inverse_matrix) .Call(wrap__compute_multiplier_output, leontief_inverse_matrix)

#' Computes direct output multiplier.
#' @param technical_coefficients_matrix The open model technical coefficients matrix.
#' @return A 1xn vector of direct output multipliers.
#' @noRd
compute_multiplier_output_direct <- function(technical_coefficients_matrix) .Call(wrap__compute_multiplier_output_direct, technical_coefficients_matrix)

#' Computes indirect output multiplier.
#' @param technical_coefficients_matrix The open model technical coefficients matrix.
#' @param leontief_inverse_matrix The open model Leontief inverse matrix.
#' @return A 1xn vector of indirect output multipliers.
#' @noRd
compute_multiplier_output_indirect <- function(technical_coefficients_matrix, leontief_inverse_matrix) .Call(wrap__compute_multiplier_output_indirect, technical_coefficients_matrix, leontief_inverse_matrix)

#' @description
#' Computes requirements for a given value-added vector (direct multiplier).
#'
#' @details
#' For others value-added components that doesn't get dedicated slots in the input-output table,
#' users can calculate multipliers by:
#'
#' 1. computing the requirements for a given value-added vector;
#' 2. computing the generator matrix for a given value-added vector;
#' 3. and, finally, computing the multiplier for a given value-added vector.
#'
#' Current implementation follows \insertCite{vale_alise_2020}{fio}.
#'
#' @param value_added_element A value-added vector.
#' @param total_production The total production vector.
#' @return A 1xn vector of a given value-added coefficients.
#'
#' @references \insertAllCited{}
#'
#' @examples
#' # data
#' transporation_revenue <- c(100, 200, 300)
#' total_production <- c(1000, 2000, 3000)
#' # compute requirements
#' reqs <- compute_requirements_value_added(transporation_revenue, total_production)
#' reqs
#'
#' @noRd
compute_requirements_value_added <- function(value_added_element, total_production) .Call(wrap__compute_requirements_value_added, value_added_element, total_production)

#' Computes generator matrix for a given value-added vector.
#' @param value_added_requirements The coefficients for a given value-added vector.
#' @param leontief_inverse_matrix The open model Leontief inverse matrix.
#' @return A nxn matrix of an value-added vector generator.
#' @noRd
compute_generator_value_added <- function(value_added_requirements, leontief_inverse_matrix) .Call(wrap__compute_generator_value_added, value_added_requirements, leontief_inverse_matrix)

#' @description
#' Computes multiplier for a given value-added vector.
#'
#' @details
#' For others value-added components that doesn't get dedicated slots in the input-output table,
#' users can calculate multipliers by:
#'
#' 1. computing the requirements for a given value-added vector;
#' 2. computing the generator matrix for a given value-added vector;
#' 3. and, finally, computing the multiplier for a given value-added vector.
#'
#' Current implementation follows \insertCite{vale_alise_2020}{fio}.
#'
#' @param value_added_requirements The coefficients for a given value-added vector.
#' @param leontief_inverse_matrix The open model Leontief inverse matrix.
#'
#' @return A 1xn vector of a given value-added multipliers.
#'
#' @references \insertAllCited{}
#'
#' @examples
#' # data
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' transporation_revenue <- c(100, 200, 300)
#' total_production <- c(1750, 2500, 3800)
#' # get technical coefficients matrix using unexported function
#' tech_coeffs <- fio:::compute_tech_coeff(intermediate_transactions, total_production)
#' # get Leontief inverse matrix using unexported function
#' leontief_inverse <- fio:::compute_leontief_inverse(tech_coeffs)
#' # get requirements
#' reqs <- compute_requirements_value_added(transporation_revenue, total_production)
#' # get multipliers
#' multipliers <- compute_multiplier_value_added(reqs, leontief_inverse)
#' multipliers
#'
#' @noRd
compute_multiplier_value_added <- function(value_added_requirements, leontief_inverse_matrix) .Call(wrap__compute_multiplier_value_added, value_added_requirements, leontief_inverse_matrix)

#' Computes indirect multiplier for a given value-added vector.
#' @param value_added_element An value-added vector.
#' @param total_production The total production vector.
#' @param leontief_inverse_matrix The open model Leontief inverse matrix.
#' @return A 1xn vector of indirect multipliers for a given value-added vector.
#' @noRd
compute_multiplier_value_added_indirect <- function(value_added_element, total_production, leontief_inverse_matrix) .Call(wrap__compute_multiplier_value_added_indirect, value_added_element, total_production, leontief_inverse_matrix)

#' @description
#' Computes the field of influence for all sectors.
#' 
#' @details
#' The field of influence shows how changes in direct coefficients are
#' distributed throughout the entire economic system, allowing for the
#' determination of which relationships between sectors are most important
#' within the production process.
#' 
#' It determines which sectors have the greatest influence over others,
#' specifically, which coefficients, when altered, would have the greatest
#' impact on the system as a whole \insertCite{vale_alise_2020}{fio}.
#' 
#' @param tech_coeff_matrix A nxn matrix of technical coefficients.
#' @param leontief_inverse_matrix The open model nxn Leontief inverse matrix.
#' @param epsilon The epsilon value.
#'
#' @return Field of influence matrix.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @examples
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' total_production <- matrix(c(100, 200, 300), 1, 3)
#' # instantiate iom object
#' my_iom <- fio::iom$new("test", intermediate_transactions, total_production)
#' # calculate the technical coefficients
#' my_iom$compute_tech_coeff()
#' # calculate the Leontief inverse
#' my_iom$compute_leontief_inverse()
#' # calculate field of influence
#' my_iom$compute_field_influence(epsilon = 0.01)
#' my_iom$field_influence
#' 
#' @noRd
compute_field_influence <- function(tech_coeff_matrix, leontief_inverse_matrix, epsilon) .Call(wrap__compute_field_influence, tech_coeff_matrix, leontief_inverse_matrix, epsilon)

#' Computes power of dispersion coefficients of variation
#' @param leontief_inverse_matrix A nxn matrix of Leontief inverse.
#' @return A vector of power of dispersion coefficients of variation.
#' @noRd
compute_power_dispersion_cv <- function(leontief_inverse_matrix) .Call(wrap__compute_power_dispersion_cv, leontief_inverse_matrix)

#' Computes sensitivity of dispersion coefficients of variation
#' @param leontief_inverse_matrix A nxn matrix of Leontief or Ghosh inverse.
#' @return A vector of sensitivity of dispersion coefficients of variation.
#' @noRd
compute_sensitivity_dispersion_cv <- function(matrix) .Call(wrap__compute_sensitivity_dispersion_cv, matrix)

#' Computes power of dispersion
#' @param leontief_inverse_matrix A nxn matrix of Leontief inverse.
#' @return A vector of power of dispersion.
#' @noRd
compute_power_dispersion <- function(leontief_inverse_matrix) .Call(wrap__compute_power_dispersion, leontief_inverse_matrix)

#' @description Computes sensitivity of dispersion
#' @param matrix A nxn matrix of Leontief or Ghosh inverse.
#' @return A vector of sensitivity of dispersion.
#' @noRd
compute_sensitivity_dispersion <- function(matrix) .Call(wrap__compute_sensitivity_dispersion, matrix)

#' Computes allocation coefficients matrix.
#' 
#' @param intermediate_transactions
#' A nxn matrix of intermediate transactions.
#' @param total_production
#' A 1xn vector of total production.
#' 
#' @details
#' Allocation coefficients matrix is the rowwise ratio of
#' intermediate transactions to total production \insertCite{miller_input-output_2009}{fio}.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @examples
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' total_production <- matrix(c(100, 200, 300), 1, 3)
#' # instantiate iom object
#' my_iom <- fio::iom$new("test", intermediate_transactions, total_production)
#' # Calculate the allocation coefficients
#' my_iom$compute_allocation_coeff()
#' # show the allocation coefficients
#' my_iom$allocation_coefficients_matrix
#' 
#' @return A nxn matrix of allocation coefficients, known as F matrix.
#' 
#' @noRd
compute_allocation_coeff <- function(intermediate_transactions, total_production) .Call(wrap__compute_allocation_coeff, intermediate_transactions, total_production)

#' Computes Ghosh inverse matrix.
#' 
#' @param allocation_coeff
#' A \eqn{n x n} matrix of allocation coefficients.
#' 
#' @details
#' The Ghosh inverse matrix is the inverse of the
#' difference \eqn{(I - F)} where I is the identity matrix and F is the
#' allocation coefficients matrix \insertCite{miller_input-output_2009}{fio}.
#' 
#' @return
#' A \eqn{n x n} matrix of Ghoshian inverse.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @noRd
compute_ghosh_inverse <- function(allocation_coeff) .Call(wrap__compute_ghosh_inverse, allocation_coeff)

#' Computes backward linkage extraction.
#' 
#' @description
#' Computes impact on demand structure after extracting a given sector \insertCite{miller_input-output_2009}{fio}.
#' 
#' @param technical_coefficients_matrix
#' A nxn matrix of technical coefficients.
#' @param final_demand_matrix
#' The final demand matrix.
#' @param total_production
#' A 1xn vector of total production.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @noRd
compute_extraction_backward <- function(technical_coefficients_matrix, final_demand_matrix, total_production) .Call(wrap__compute_extraction_backward, technical_coefficients_matrix, final_demand_matrix, total_production)

#' Computes forward linkage extraction.
#' 
#' @description
#' Computes impact on supply structure after extracting a given sector \insertCite{miller_input-output_2009}{fio}.
#' 
#' @param matrix A nxn matrix of technical or allocation coefficients.
#' @param value_added_matrix The value-added matrix.
#' @param total_production A 1xn vector of total production.
#' 
#' @references
#' \insertAllCited{}
#' 
#' @noRd
compute_extraction_forward <- function(matrix, value_added_matrix, total_production) .Call(wrap__compute_extraction_forward, matrix, value_added_matrix, total_production)

#' Computes total impact after extracting a given sector.
#' @param backward_linkage_matrix A nx2 matrix of backward linkage.
#' @param forward_linkage_matrix A nx2 matrix of forward linkage.
#' @details
#' Here we define total impact as the sum of impact on demand and supply structures
#' after removal of a given sector.
#' 
#' @seealso `compute_extraction_backwards()` and `compute_extraction_forward()`.
#' 
#' @examples
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' total_production <- matrix(c(100, 200, 300), 1, 3)
#' exports <- matrix(c(10, 20, 30), 3, 1)
#' imports <- matrix(c(5, 10, 15), 1, 3)
#' # instantiate iom object
#' my_iom <- fio::iom$new(
#'   "test",
#'   intermediate_transactions,
#'   total_production,
#'   exports = exports,
#'   imports = imports
#' )
#' 
#' # Calculate the technical coefficients
#' my_iom$compute_tech_coeff()
#' # calculate the Leontief inverse
#' my_iom$compute_allocation_coeff()
#' # aggregate final demand and value-added matrices
#' my_iom$update_value_added_matrix()
#' my_iom$update_final_demand_matrix()
#' # Calculate effects on both demand and supply structures after extracting a sector
#' my_iom$compute_hypothetical_extraction()
#' # show results
#' my_iom$hypothetical_extraction
#' 
#' @noRd
compute_extraction_total <- function(backward_linkage_matrix, forward_linkage_matrix) .Call(wrap__compute_extraction_total, backward_linkage_matrix, forward_linkage_matrix)

#' Sets max number of threads used by fio
#'
#' @details
#' Calling this function sets a global limit of threads to Rayon crate, affecting
#' all computations that runs in parallel by default.
#'
#' Default behavior of Rayon is to use all available threads (including logical).
#' Setting to 1 will result in single threaded (sequential) computations.
#'
#' Initialization of the global thread pool happens exactly once.
#' Once started, the configuration cannot be changed in the current session.
#' If `set_max_threads()` is called again in the same session, it'll result
#' in an error.
#'
#' @param max_threads Int.
#' Default is 0 (all threads available). 1 means single threaded.
#'
#' @return
#' This functions does not return a value.
#'
#' @examples
#' intermediate_transactions <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), 3, 3)
#' total_production <- matrix(c(100, 200, 300), 1, 3)
#' # instantiate iom object
#' my_iom <- fio::iom$new("test", intermediate_transactions, total_production)
#' # to run single threaded (sequential)
#' my_iom$set_max_threads(1L)
#'
#' @noRd
set_max_threads <- function(max_threads) invisible(.Call(wrap__set_max_threads, max_threads))


# nolint end
