% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_iom.R
\name{import_element}
\alias{import_element}
\title{Import IOM data}
\usage{
import_element(file, sheet, range, col_names = FALSE, row_names = FALSE)
}
\arguments{
\item{file}{Path to the Excel file.}

\item{sheet}{Name of the sheet in the Excel file.}

\item{range}{Range of cells in the Excel file.}

\item{col_names}{Range of cells with column names.}

\item{row_names}{Range of cells with row names.}
}
\value{
A (\code{matrix}).
}
\description{
Import data from a input-output matrix (IOM) from Excel format.
}
\examples{
if (isNamespaceLoaded("fiodata")) {
 # Excel file with IOM data
 path_to_xlsx <- system.file("extdata", "/2020.xlsx", package = "fiodata")
 # Import IOM data
 intermediate_transactions <- import_element(
   file = path_to_xlsx,
   sheet = "iom",
   range = "D6:BB56",
   col_names = "D4:BB4",
   row_names = "B6:B56"
 )
 # Show the first 6 rows and 6 columns
 intermediate_transactions[1:6, 1:6]
}
}
