% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVARMxID-fit-dt-var-mx-id.R
\name{FitVARMxID}
\alias{FitVARMxID}
\title{Fit the First-Order Vector Autoregressive Model by ID}
\usage{
FitVARMxID(
  data,
  observed,
  id,
  time = NULL,
  ct = FALSE,
  center = TRUE,
  mu_fixed = FALSE,
  mu_free = NULL,
  mu_values = NULL,
  mu_lbound = NULL,
  mu_ubound = NULL,
  alpha_fixed = FALSE,
  alpha_free = NULL,
  alpha_values = NULL,
  alpha_lbound = NULL,
  alpha_ubound = NULL,
  beta_fixed = FALSE,
  beta_free = NULL,
  beta_values = NULL,
  beta_lbound = NULL,
  beta_ubound = NULL,
  psi_diag = FALSE,
  psi_fixed = FALSE,
  psi_d_free = NULL,
  psi_d_values = NULL,
  psi_d_lbound = NULL,
  psi_d_ubound = NULL,
  psi_d_equal = FALSE,
  psi_l_free = NULL,
  psi_l_values = NULL,
  psi_l_lbound = NULL,
  psi_l_ubound = NULL,
  nu_fixed = TRUE,
  nu_free = NULL,
  nu_values = NULL,
  nu_lbound = NULL,
  nu_ubound = NULL,
  theta_diag = TRUE,
  theta_fixed = TRUE,
  theta_d_free = NULL,
  theta_d_values = NULL,
  theta_d_lbound = NULL,
  theta_d_ubound = NULL,
  theta_d_equal = FALSE,
  theta_l_free = NULL,
  theta_l_values = NULL,
  theta_l_lbound = NULL,
  theta_l_ubound = NULL,
  mu0_fixed = TRUE,
  mu0_func = TRUE,
  mu0_free = NULL,
  mu0_values = NULL,
  mu0_lbound = NULL,
  mu0_ubound = NULL,
  sigma0_fixed = TRUE,
  sigma0_func = TRUE,
  sigma0_diag = FALSE,
  sigma0_d_free = NULL,
  sigma0_d_values = NULL,
  sigma0_d_lbound = NULL,
  sigma0_d_ubound = NULL,
  sigma0_d_equal = FALSE,
  sigma0_l_free = NULL,
  sigma0_l_values = NULL,
  sigma0_l_lbound = NULL,
  sigma0_l_ubound = NULL,
  robust = FALSE,
  seed = NULL,
  tries_explore = 100,
  tries_local = 100,
  max_attempts = 10,
  silent = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{Data frame.
A data frame object of data for potentially
multiple subjects that contain
a column of subject ID numbers
(i.e., an ID variable), and
at least one column of observed values.}

\item{observed}{Character vector.
A vector of character strings
of the names of the observed variables in the data.}

\item{id}{Character string.
A character string of the name of the ID variable in the data.}

\item{time}{Character string.
A character string of the name of the TIME variable in the data.
Used when \code{ct = TRUE}.}

\item{ct}{Logical.
If TRUE, fit a continuous-time vector autoregressive model.
If FALSE, fit a discrete-time vector autoregressive model.}

\item{center}{Logical.
If \code{TRUE}, use the mean-centered (mean-reverting) state equation.
When \code{center = TRUE}, \code{alpha} is implied and the set-point \code{mu} is
estimated. When \code{center = FALSE},
\code{alpha} is estimated and \code{mu} is implied.}

\item{mu_fixed}{Logical.
If \code{TRUE}, the set-point mean vector \code{mu}
is fixed to \code{mu_values}.
If \code{mu_fixed = TRUE} and \code{mu_values = NULL},
\code{mu} is fixed to a zero vector.
If \code{FALSE}, \code{mu} is estimated.}

\item{mu_free}{Logical vector indicating
which elements of \code{mu} are freely estimated.
If \code{NULL}, all elements are free.
Ignored if \code{mu_fixed = TRUE}.}

\item{mu_values}{Numeric vector of values for \code{mu}.
If \code{mu_fixed = TRUE}, these are fixed values.
If \code{mu_fixed = FALSE}, these are starting values.
If \code{NULL}, defaults to a vector of zeros.}

\item{mu_lbound}{Numeric vector of lower bounds for \code{mu}.
Ignored if \code{mu_fixed = TRUE}.}

\item{mu_ubound}{Numeric vector of upper bounds for \code{mu}.
Ignored if \code{mu_fixed = TRUE}.}

\item{alpha_fixed}{Logical.
If \code{TRUE},
the dynamic model intercept vector \code{alpha}
is fixed to \code{alpha_values}.
If \code{FALSE}, \code{alpha} is estimated.}

\item{alpha_free}{Logical vector indicating
which elements of \code{alpha} are freely estimated.
If \code{NULL}, all elements are free.
Ignored if \code{alpha_fixed = TRUE}.}

\item{alpha_values}{Numeric vector of values for \code{alpha}.
If \code{alpha_fixed = TRUE}, these are fixed values.
If \code{alpha_fixed = FALSE}, these are starting values.
If \code{NULL}, defaults to a vector of zeros.}

\item{alpha_lbound}{Numeric vector of lower bounds for \code{alpha}.
Ignored if \code{alpha_fixed = TRUE}.}

\item{alpha_ubound}{Numeric vector of upper bounds for \code{alpha}.
Ignored if \code{alpha_fixed = TRUE}.}

\item{beta_fixed}{Logical.
If \code{TRUE}, the dynamic model coefficient matrix \code{beta} is fixed.
If \code{FALSE}, \code{beta} is estimated.}

\item{beta_free}{Logical matrix indicating
which elements of \code{beta} are freely estimated.
If \code{NULL}, all elements are free.
Ignored if \code{beta_fixed = TRUE}.}

\item{beta_values}{Numeric matrix.
Values for \code{beta}.
If \code{beta_fixed = TRUE}, these are fixed values;
if \code{beta_fixed = FALSE}, these are starting values.
If \code{NULL}, defaults to a diagonal matrix
with -0.001 when \code{ct = TRUE} and 0.001 when \code{ct = FALSE}.}

\item{beta_lbound}{Numeric matrix of lower bounds for \code{beta}.
If \code{NULL}, defaults to -2.5.
Ignored if \code{beta_fixed = TRUE}.}

\item{beta_ubound}{Numeric matrix.
Upper bounds for \code{beta}.
Ignored if \code{beta_fixed = TRUE}.
If \code{NULL}, defaults to \code{+2.5}.
If \code{NULL} and \code{ct = TRUE},
diagonal upper bounds are set to \code{-1e-05}.}

\item{psi_diag}{Logical.
If \code{TRUE}, \code{psi} is diagonal.
If \code{FALSE}, \code{psi} is symmetric.}

\item{psi_fixed}{Logical.
If \code{TRUE}, the process noise covariance matrix \code{psi}
is fixed using \code{psi_d_values} and \code{psi_l_values}.
If \code{psi_d_values} is \code{NULL} it is fixed to a zero matrix.
If \code{FALSE}, \code{psi} is estimated.}

\item{psi_d_free}{Logical vector
indicating free/fixed status of the elements of \code{psi_d}.
If \code{NULL}, all element of \code{psi_d} are free.}

\item{psi_d_values}{Numeric vector
with starting values for \code{psi_d}.
If \code{psi_fixed = TRUE}, these are fixed values.
If \code{psi_fixed = FALSE}, these are starting values.}

\item{psi_d_lbound}{Numeric vector
with lower bounds for \code{psi_d}.}

\item{psi_d_ubound}{Numeric vector
with upper bounds for \code{psi_d}.}

\item{psi_d_equal}{Logical.
When \code{TRUE}, all free diagonal elements of \code{psi_d} are constrained
to be equal and estimated as a single shared parameter.
Ignored if no diagonal elements are free.}

\item{psi_l_free}{Logical matrix
indicating which strictly-lower-triangular elements of \code{psi_l} are free.
If \code{NULL}, all element of \code{psi_l} are free.
Ignored if \code{psi_diag = TRUE}.}

\item{psi_l_values}{Numeric matrix
of starting values
for the strictly-lower-triangular elements of \code{psi_l}.}

\item{psi_l_lbound}{Numeric matrix
with lower bounds for \code{psi_l}.}

\item{psi_l_ubound}{Numeric matrix
with upper bounds for \code{psi_l}.}

\item{nu_fixed}{Logical.
If \code{TRUE},
the measurement model intercept vector \code{nu}
is fixed to \code{nu_values}.
If \code{FALSE}, \code{nu} is estimated.}

\item{nu_free}{Logical vector indicating
which elements of \code{nu} are freely estimated.
If \code{NULL}, all elements are free.
Ignored if \code{nu_fixed = TRUE}.}

\item{nu_values}{Numeric vector of values for \code{nu}.
If \code{nu_fixed = TRUE}, these are fixed values.
If \code{nu_fixed = FALSE}, these are starting values.
If \code{NULL}, defaults to a vector of zeros.}

\item{nu_lbound}{Numeric vector of lower bounds for \code{nu}.
Ignored if \code{nu_fixed = TRUE}.}

\item{nu_ubound}{Numeric vector of upper bounds for \code{nu}.
Ignored if \code{nu_fixed = TRUE}.}

\item{theta_diag}{Logical.
If \code{TRUE}, \code{theta} is diagonal.
If \code{FALSE}, \code{theta} is symmetric.}

\item{theta_fixed}{Logical.
If \code{TRUE}, the measurement error covariance matrix \code{theta}
is fixed using \code{theta_d_values} and \code{theta_l_values}.
If \code{theta_d_values} is \code{NULL} it is fixed to a zero matrix.
If \code{FALSE}, \code{theta} is estimated.}

\item{theta_d_free}{Logical vector
indicating free/fixed status of the diagonal parameters \code{theta_d}.
If \code{NULL}, all element of \code{theta_d} are free.}

\item{theta_d_values}{Numeric vector
with starting values for \code{theta_d}.
If \code{theta_fixed = TRUE}, these are fixed values.
If \code{theta_fixed = FALSE}, these are starting values.}

\item{theta_d_lbound}{Numeric vector
with lower bounds for \code{theta_d}.}

\item{theta_d_ubound}{Numeric vector
with upper bounds for \code{theta_d}.}

\item{theta_d_equal}{Logical.
When \code{TRUE}, all free diagonal elements of \code{theta_d} are constrained
to be equal and estimated as a single shared parameter.
Ignored if no diagonal elements are free.}

\item{theta_l_free}{Logical matrix
indicating which strictly-lower-triangular elements of \code{theta_l} are free.
If \code{NULL}, all element of \code{theta_l} are free.
Ignored if \code{theta_diag = TRUE}.}

\item{theta_l_values}{Numeric matrix
of starting values
for the strictly-lower-triangular elements of \code{theta_l}.}

\item{theta_l_lbound}{Numeric matrix
with lower bounds for \code{theta_l}.}

\item{theta_l_ubound}{Numeric matrix
with upper bounds for \code{theta_l}.}

\item{mu0_fixed}{Logical.
If \code{TRUE}, the initial mean vector \code{mu0} is fixed.
If \code{mu0_fixed = TRUE} and \code{mu0_func = TRUE},
\code{mu0} is fixed to the implied stable mean vector.
If \code{mu0_fixed = TRUE} and \code{mu0_values = NULL},
\code{mu0} is fixed to a zero vector.
If \code{FALSE}, \code{mu0} is estimated.}

\item{mu0_func}{Logical.
If \code{TRUE} and \code{mu0_fixed = TRUE},
\code{mu0} is fixed to the implied stable mean vector.}

\item{mu0_free}{Logical vector indicating
which elements of \code{mu0} are free.
Ignored if \code{mu0_fixed = TRUE}.}

\item{mu0_values}{Numeric vector of values for \code{mu0}.
If \code{mu0_fixed = TRUE}, these are fixed values.
If \code{mu0_fixed = FALSE}, these are starting values.
If \code{NULL}, defaults to a vector of zeros.
Ignored if \code{mu0_fixed = TRUE} and \code{mu0_func = TRUE}.}

\item{mu0_lbound}{Numeric vector of lower bounds for \code{mu0}.
Ignored if \code{mu0_fixed = TRUE}.}

\item{mu0_ubound}{Numeric vector of upper bounds for \code{mu0}.
Ignored if \code{mu0_fixed = TRUE}.}

\item{sigma0_fixed}{Logical.
If \code{TRUE}, the initial condition covariance matrix \code{sigma0}
is fixed using \code{sigma0_d_values} and \code{sigma0_l_values}.
If \code{sigma0_fixed = TRUE} and \code{sigma0_func = TRUE},
\code{sigma0} is fixed to the implied stable covariance matrix.
If \code{sigma0_fixed = TRUE} and \code{sigma0_d_values = NULL},
\code{sigma0} is fixed to a diffused matrix.}

\item{sigma0_func}{Logical.
If \code{TRUE} and \code{sigma0_fixed = TRUE}, \code{sigma0} is fixed to
the implied stable covariance matrix.}

\item{sigma0_diag}{Logical.
If \code{TRUE}, \code{sigma0} is diagonal.
If \code{FALSE}, \code{sigma0} is symmetric.}

\item{sigma0_d_free}{Logical vector
indicating free/fixed status of the elements of \code{sigma0_d}.
If \code{NULL}, all element of \code{sigma0_d} are free.}

\item{sigma0_d_values}{Numeric vector
with starting values for \code{sigma0_d}.
If \code{sigma0_fixed = TRUE}, these are fixed values.
If \code{sigma0_fixed = FALSE}, these are starting values.}

\item{sigma0_d_lbound}{Numeric vector
with lower bounds for \code{sigma0_d}.}

\item{sigma0_d_ubound}{Numeric vector
with upper bounds for \code{sigma0_d}.}

\item{sigma0_d_equal}{Logical.
When \code{TRUE}, all free diagonal elements of \code{sigma0_d} are constrained
to be equal and estimated as a single shared parameter.
Ignored if no diagonal elements are free.}

\item{sigma0_l_free}{Logical matrix
indicating which strictly-lower-triangular elements of \code{sigma0_l} are free.
If \code{NULL}, all element of \code{sigma0_l} are free.
Ignored if \code{sigma0_diag = TRUE}.}

\item{sigma0_l_values}{Numeric matrix
of starting values
for the strictly-lower-triangular elements of \code{sigma0_l}.}

\item{sigma0_l_lbound}{Numeric matrix
with lower bounds for \code{sigma0_l}.}

\item{sigma0_l_ubound}{Numeric matrix
with upper bounds for \code{sigma0_l}.}

\item{robust}{Logical.
If \code{TRUE}, calculate robust (sandwich) sampling variance-covariance matrix.}

\item{seed}{Random seed for reproducibility.}

\item{tries_explore}{Integer.
Number of extra tries for the wide exploration phase.}

\item{tries_local}{Integer.
Number of extra tries for local polishing.}

\item{max_attempts}{Integer.
Maximum number of remediation attempts
after the first Hessian computation fails the criteria.}

\item{silent}{Logical.
If \code{TRUE}, suppresses messages during the model fitting stage.}

\item{ncores}{Positive integer.
Number of cores to use.}
}
\value{
Returns an object of class \code{varmxid} which is
a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{List of function arguments.}
\item{fun}{Function used ("FitVARMxID").}
\item{model}{A list of generated OpenMx models.}
\item{output}{A list of fitted OpenMx models.}
\item{converged}{A logical vector indicating converged cases.}
\item{robust}{A list of output from \code{\link[OpenMx:imxRobustSE]{OpenMx::imxRobustSE()}}
with argument \code{details = TRUE} for each \code{id}
if \code{robust = TRUE}.}
}
}
\description{
The function fits
the first-order vector autoregressive model
for each unit ID.
}
\details{
\subsection{Measurement Model}{

By default, the measurement model is given by
\deqn{
  \mathbf{y}_{i, t}
  =
  \boldsymbol{\eta}_{i, t} .
}
However, the full measurement model can be parameterized as follows
\deqn{
  \mathbf{y}_{i, t}
  =
  \boldsymbol{\nu}_{i}
  +
  \boldsymbol{\Lambda}
  \boldsymbol{\eta}_{i, t}
  +
  \boldsymbol{\varepsilon}_{i, t},
  \quad
  \mathrm{with}
  \quad
  \boldsymbol{\varepsilon}_{i, t}
  \sim
  \mathcal{N}
  \left(
  \mathbf{0},
  \boldsymbol{\Theta}_{i}
  \right)
}
where
\eqn{\mathbf{y}_{i, t}},
\eqn{\boldsymbol{\eta}_{i, t}},
and
\eqn{\boldsymbol{\varepsilon}_{i, t}}
are random variables
and
\eqn{\boldsymbol{\nu}_{i}},
\eqn{\boldsymbol{\Lambda}},
and
\eqn{\boldsymbol{\Theta}_{i}}
are model parameters.
\eqn{\mathbf{y}_{i, t}}
represents a vector of observed random variables,
\eqn{\boldsymbol{\eta}_{i, t}}
a vector of latent random variables,
and
\eqn{\boldsymbol{\varepsilon}_{i, t}}
a vector of random measurement errors,
at time \eqn{t} and individual \eqn{i}.
\eqn{\boldsymbol{\nu}_{i}},
denotes a vector of intercepts (fixed to a null vector by default),
\eqn{\boldsymbol{\Lambda}}
a matrix of factor loadings,
and
\eqn{\boldsymbol{\Theta}_{i}}
the covariance matrix of
\eqn{\boldsymbol{\varepsilon}}.
In this model,
\eqn{\boldsymbol{\Lambda}} is an identity matrix and
\eqn{\boldsymbol{\Theta}_{i}} is a diagonal matrix.
}

\subsection{Discrete-Time Dynamic Structure}{

The dynamic structure is given by
\deqn{
  \boldsymbol{\eta}_{i, t}
  =
  \boldsymbol{\alpha}_{i}
  +
  \boldsymbol{\beta}_{i}
  \boldsymbol{\eta}_{i, t - 1}
  +
  \boldsymbol{\zeta}_{i, t},
  \quad
  \mathrm{with}
  \quad
  \boldsymbol{\zeta}_{i, t}
  \sim
  \mathcal{N}
  \left(
  \mathbf{0},
  \boldsymbol{\Psi}_{i}
  \right)
}
where
\eqn{\boldsymbol{\eta}_{i, t}},
\eqn{\boldsymbol{\eta}_{i, t - 1}},
and
\eqn{\boldsymbol{\zeta}_{i, t}}
are random variables,
and
\eqn{\boldsymbol{\alpha}_{i}},
\eqn{\boldsymbol{\beta}_{i}},
and
\eqn{\boldsymbol{\Psi}_{i}}
are model parameters.
Here,
\eqn{\boldsymbol{\eta}_{i, t}}
is a vector of latent variables
at time \eqn{t} and individual \eqn{i},
\eqn{\boldsymbol{\eta}_{i, t - 1}}
represents a vector of latent variables
at time \eqn{t - 1} and individual \eqn{i},
and
\eqn{\boldsymbol{\zeta}_{i, t}}
represents a vector of dynamic noise
at time \eqn{t} and individual \eqn{i}.
\eqn{\boldsymbol{\alpha}_{i}}
denotes a vector of intercepts,
\eqn{\boldsymbol{\beta}_{i}}
a matrix of autoregression
and cross regression coefficients,
and
\eqn{\boldsymbol{\Psi}_{i}}
the covariance matrix of
\eqn{\boldsymbol{\zeta}_{i, t}}.

If \code{center = TRUE}, the dynamic structure is parameterized as follows
\deqn{
  \boldsymbol{\eta}_{i, t}
  =
  \boldsymbol{\mu}_{i}
  +
  \boldsymbol{\beta}_{i}
  \left(
    \boldsymbol{\eta}_{i, t - 1}
    -
    \boldsymbol{\mu}_{i}
  \right)
  +
  \boldsymbol{\zeta}_{i, t}
}
where \eqn{\boldsymbol{\mu}_{i}}
is equilibrium level of the latent state
toward which the system is pulled over time.
}

\subsection{Continuous-Time Dynamic Structure}{

The continuous-time parameterization, when \code{ct = TRUE},
for the dynamic structure is given by
\deqn{
  \mathrm{d}
  \boldsymbol{\eta}_{i, t}
  =
  \left(
  \boldsymbol{\alpha}_{i}
  +
  \boldsymbol{\beta}_{i}
  \boldsymbol{\eta}_{i, t - 1}
  \right)
  \mathrm{d} t
  +
  \boldsymbol{\Psi}_{i}^{\frac{1}{2}}
  \mathrm{d}
  \mathbf{W}_{i, t}
}
note that \eqn{\mathrm{d}\boldsymbol{W}}
is a Wiener process or Brownian motion,
which represents random fluctuations.

If \code{center = TRUE}, the dynamic structure is parameterized as follows
\deqn{
  \mathrm{d}
  \boldsymbol{\eta}_{i, t}
  =
  \boldsymbol{\beta}_{i}
  \left(
    \boldsymbol{\eta}_{i, t - 1}
    -
    \boldsymbol{\mu}_{i}
  \right)
  \mathrm{d} t
  +
  \boldsymbol{\Psi}_{i}^{\frac{1}{2}}
  \mathrm{d}
  \mathbf{W}_{i, t}
}
}
}
\examples{
\donttest{
# Generate data using the simStateSpace package-------------------------
library(simStateSpace)
set.seed(42)
n <- 5
time <- 100
p <- 2
alpha <- rep(x = 0, times = p)
beta <- 0.50 * diag(p)
psi <- 0.001 * diag(p)
psi_l <- t(chol(psi))
mu0 <- simStateSpace::SSMMeanEta(
  beta = beta,
  alpha = alpha
)
sigma0 <- simStateSpace::SSMCovEta(
  beta = beta,
  psi = psi
)
sigma0_l <- t(chol(sigma0))
sim <- SimSSMVARFixed(
  n = n,
  time = time,
  mu0 = mu0,
  sigma0_l = sigma0_l,
  alpha = alpha,
  beta = beta,
  psi_l = psi_l
)
data <- as.data.frame(sim)

# Fit the model---------------------------------------------------------
# center = TRUE
library(fitVARMxID)
fit <- FitVARMxID(
  data = data,
  observed = paste0("y", seq_len(p)),
  id = "id",
  center = TRUE
)
print(fit)
summary(fit)
coef(fit)
vcov(fit)
converged(fit)

# Fit the model---------------------------------------------------------
# center = FALSE
library(fitVARMxID)
fit <- FitVARMxID(
  data = data,
  observed = paste0("y", seq_len(p)),
  id = "id",
  center = FALSE
)
print(fit)
summary(fit)
coef(fit)
vcov(fit)
converged(fit)
}

}
\references{
Hunter, M. D. (2017).
State space modeling in an open source, modular,
structural equation modeling environment.
\emph{Structural Equation Modeling: A Multidisciplinary Journal},
\emph{25}(2), 307–324.
\doi{10.1080/10705511.2017.1369354}

Neale, M. C., Hunter, M. D., Pritikin, J. N.,
Zahery, M., Brick, T. R., Kirkpatrick, R. M., Estabrook, R.,
Bates, T. C., Maes, H. H., & Boker, S. M. (2015).
OpenMx 2.0: Extended structural equation and statistical modeling.
\emph{Psychometrika},
\emph{81}(2), 535–549.
\doi{10.1007/s11336-014-9435-8}
}
\seealso{
Other VAR Functions: 
\code{\link{LDL}()},
\code{\link{Softplus}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{VAR Functions}
\keyword{fit}
\keyword{fitVARMxID}
