% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVARMxID-softplus.R
\name{Softplus}
\alias{Softplus}
\alias{InvSoftplus}
\title{Softplus and Inverse Softplus Transformations}
\usage{
Softplus(x)

InvSoftplus(x)
}
\arguments{
\item{x}{Numeric vector or matrix.
Input values to be transformed.}
}
\value{
\itemize{
\item \code{Softplus()}: numeric vector or matrix of nonnegative values
(mathematically strictly positive for finite inputs, but can underflow
to 0 for very negative values).
\item \code{InvSoftplus()}: numeric vector or matrix of unconstrained values.
}
}
\description{
The softplus transformation maps unconstrained real values to the
positive real line. This is useful when parameters (e.g., variances)
must be positive. The inverse softplus transformation
recovers the unconstrained value from a strictly positive input.
}
\details{
Mathematical definitions:
\itemize{
\item \code{Softplus(x) = log(1 + exp(x))}
\item \code{InvSoftplus(x) = log(exp(x) - 1)}
}

Numerical implementation (stable forms):
\itemize{
\item \code{Softplus(x) = max(x, 0) + log1p(exp(-abs(x)))}
\item \code{InvSoftplus(y)} uses \code{log(expm1(y))}, and for large \code{y} uses the rewrite
\code{y + log1p(-exp(-y))} for stability.
}

For numerical stability, these functions use \code{log1p()} and \code{expm1()}
internally. \code{InvSoftplus()} requires strictly positive input and will
error if any values are \verb{<= 0}.
}
\examples{
# Apply softplus to unconstrained values
x <- c(-5, 0, 5)
y <- Softplus(x)

# Recover unconstrained values
x_recovered <- InvSoftplus(y)

y
x_recovered

}
\seealso{
Other VAR Functions: 
\code{\link{FitVARMxID}()},
\code{\link{LDL}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{VAR Functions}
\keyword{fitVARMxID}
\keyword{misc}
