% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{as.fmt.data.frame}
\alias{as.fmt.data.frame}
\title{Convert a data frame to a user-defined format}
\usage{
\method{as.fmt}{data.frame}(x)
}
\arguments{
\item{x}{The data frame to convert.}
}
\value{
A format catalog based on the information contained in the 
input data frame.
}
\description{
This function takes a data frame as input
and converts it to a user-defined format based on the information contained
in the data frame. The data frame should have 5 columns: "Name", "Type",
"Expression", "Label" and "Order".
}
\details{
The \code{as.fmt.data.frame} function converts a data frame to a 
user-defined format. 

To understand the structure of the input data frame, create a user-defined 
format and use the \code{as.data.frame} method to convert the format 
to a data frame.
Then observe the columns and organization of the data.
}
\section{Input Data Frame Specifications}{

The input data frame should contain the following columns:
\itemize{
\item \strong{Name}: The name of the format
\item \strong{Type}: The type of format.  See the type codes below.
\item \strong{Expression}: The formatting expression. The expression will 
hold different types of values depending on the format type.  Within the
data frame, this expression is stored as a character string.
\item \strong{Label}: The label for user-defined, "U" type formats.
\item \strong{Order}: The order for user-defined, "U" type formats. 
\item \strong{Factor}: An optional column for "U" type formats that sets
the "as.factor" parameter. Valid values are TRUE, FALSE, or NA. 
}
Any additional columns will be ignored.  Column names are case-insensitive.

Valid values for the "Type" column are as follows:
\itemize{
\item \strong{U}: User Defined List created with the \code{\link{value}} 
function.
\item \strong{S}: A formatting string of formatting codes.  
See \link{FormattingStrings}.
\item \strong{F}: A vectorized function.
\item \strong{V}: A named vector lookup.}

The "Label", "Order", and "Factor" columns are used only for a type "U", user-defined
format created with the \code{\link{value}} function.
}

\examples{
# Create a user-defined format 
f1 <- value(condition(x == "A", "Label A"),
            condition(x == "B", "Label B"),
            condition(TRUE, "Other"))
           
# Convert user-defined format to data frame to view the structure
df <- as.data.frame(f1)
print(df)

# Name Type Expression   Label Order Factor
# 1 f1    U   x == "A" Label A    NA  FALSE
# 2 f1    U   x == "B" Label B    NA  FALSE
# 3 f1    U       TRUE   Other    NA  FALSE

# Convert data frame back to a user-defined format 
f2 <- as.fmt(df)

# Use re-converted format
fapply(c("A", "B", "C", "B"), f2)
# [1] "Label A" "Label B" "Other"   "Label B"
}
\seealso{
Other fmt: 
\code{\link{as.data.frame.fmt}()},
\code{\link{as.fmt}()},
\code{\link{condition}()},
\code{\link{is.format}()},
\code{\link{labels.fmt}()},
\code{\link{print.fmt}()},
\code{\link{value}()}
}
\concept{fmt}
