% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{peek_iconv}
\alias{peek_iconv}
\title{Converts encoding of characters}
\usage{
peek_iconv(path, from, to = "UTF-8", newfile = NULL)
}
\arguments{
\item{path}{file path}

\item{from}{the code set in which the input
is encoded.}

\item{to}{the code set to which the output is
to be converted.}

\item{newfile}{result file. Default to NULL. If null the
result will be print in the R console, otherwise a
file is produced containing the result.}
}
\description{
Read a file, convert the encoding
of characters and print the result.
}
\examples{
la_cigale <- system.file(package = "fpeek", "datafiles",
  "cigfou-ISO-8859-1.txt")

peek_iconv(la_cigale, from = "ISO-8859-1", to = "UTF-8")

newfile <- tempfile()
peek_iconv(la_cigale, from = "ISO-8859-1", to = "UTF-8",
  newfile = newfile)
peek_head(newfile, n = 10)

}
