% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{simulate_data_FRTM}
\alias{simulate_data_FRTM}
\title{Simulate data for real-time monitoring of univariate functional data}
\usage{
simulate_data_FRTM(
  n_obs = 100,
  scenario = "1",
  shift = "IC",
  alignemnt_level = "M1",
  t_out_type = "0.3",
  severity = 0.5,
  grid = seq(0, 1, length.out = 100)
)
}
\arguments{
\item{n_obs}{Number of curves generated.}

\item{scenario}{A  character string indicating the scenario considered. It could be "1",  and "2".}

\item{shift}{A  character string indicating the shift considered.
It could be "IC",  in-control data, "OC_h", Shift A (Phase),"OC_x", Shift B (Amplitude) and "OC_xh", Shift C (Amplitude and Phase).}

\item{alignemnt_level}{A  character string indicating the alignment level considered. It could be "M1", "M2",  and "M3".}

\item{t_out_type}{If "0.3", change point at the 30\% of the process.  If "0.6", change point at the 60\% of the process.}

\item{severity}{Severity level.}

\item{grid}{Grid of evaluation points.}
}
\value{
A list containing the following arguments:

\code{x_err}: A list containing the discrete observations for each curve.

\code{grid_i}:  A list of vector of time points where the curves are sampled.

\code{h}: A list containing the discrete observations of the warping function  for each curve.

\code{template}: The discrete observations of the true template function.

\code{grid_template}: Time points where the template is sampled.

\code{x_true}: A list containing the discrete observations of the amplitude function for each curve.

\code{grid}: Grid of evaluation points.

\code{out_control_t}: Time of the change point.
}
\description{
Generate synthetic data as in the simulation study of Centofanti et al. (2024).
}
\examples{
library(funcharts)
data<-simulate_data_FRTM(n_obs=20)
}
\references{
Centofanti, F., A. Lepore, M. Kulahci, and M. P. Spooner (2024).
Real-time monitoring of functional data. \emph{Journal of Quality Technology}, 57(2):135--152,
doi:https://doi.org/10.1080/00224065.2024.2430978.
}
