% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-options.R
\name{zzz-futurize.options}
\alias{zzz-futurize.options}
\alias{futurize.options}
\alias{futurize.debug}
\alias{R_FUTURIZE_DEBUG}
\title{Options used by futurize}
\description{
Below are the \R options and environment variables that are used by the
\pkg{futurize} package and packages enhancing it.\cr
\cr
\emph{WARNING: Note that the names and the default values of these options may
change in future versions of the package.  Please use with care until
further notice.}
}
\section{Packages must not change future options}{


Just like for other R options, as a package developer you must \emph{not} change
any of the below \verb{futurize.*} options.  Only the end-user should set these.
If you find yourself having to tweak one of the options, make sure to
undo your changes immediately afterward.
}

\section{Options for debugging}{

\describe{
\item{\option{futurize.debug}:}{(logical) If \code{TRUE}, extensive debug messages are generated. (Default: \code{FALSE})}
}
}

\section{Environment variables that set R options}{

All of the above \R \option{futurize.*} options can be set by corresponding
environment variable \env{R_FUTURIZE_*} \emph{when the \pkg{futurize} package is
loaded}. This means that those environment variables must be set before
the \pkg{futurize} package is loaded in order to have an effect.
For example, if \code{R_FUTURIZE_DEBUG=true}, then option
\option{futurize.debug} is set to \code{TRUE} (logical).
}

\seealso{
To set \R options or environment variables when \R starts (even before the \pkg{future} package is loaded), see the \link[base]{Startup} help page.  The \href{https://cran.r-project.org/package=startup}{\pkg{startup}} package provides a friendly mechanism for configuring \R's startup process.
}
