% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodetector.R
\name{interaction_detector}
\alias{interaction_detector}
\title{interaction detector}
\usage{
interaction_detector(y, x1, x2)
}
\arguments{
\item{y}{Dependent variable, continuous numeric vector.}

\item{x1}{Covariate \eqn{X_1}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x2}{Covariate \eqn{X_2}, \code{factor}, \code{character} or \code{discrete numeric}.}
}
\value{
A list.
\describe{
\item{\code{Variable1 Q-statistics}}{Q-statistics for variable1}
\item{\code{Variable2 Q-statistics}}{Q-statistics for variable2}
\item{\code{Variable1 and Variable2 interact Q-statistics}}{Q-statistics for variable1 and variable2 interact}
\item{\code{Interaction}}{the interact result type}
\item{\code{Variable1 P-value}}{P-value of the Q-statistic for Variable1}
\item{\code{Variable2 P-value}}{P-value of the Q-statistic for Variable2}
\item{\code{Variable1 and Variable2 interact P-value}}{P-value of the Q-statistic for variable1 and variable2 interact}
}
}
\description{
Identify the interaction between different risk factors, that is, assess whether factors X1 and X2 together
increase or decrease the explanatory power of the dependent variable Y, or whether the effects of these factors
on Y are independent of each other.
}
\examples{
interaction_detector(y = 1:7,
                     x1 = c('x',rep('y',3),rep('z',3)),
                     x2 = c(rep('a',2),rep('b',2),rep('c',3)))

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
