% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{cor}
\alias{cor}
\alias{cor.default}
\alias{cor.symbolic_tbl}
\alias{cor.symbolic_interval}
\title{Generic function for the correlation}
\usage{
cor(x, ...)

\method{cor}{default}(
  x,
  y = NULL,
  use = "everything",
  method = c("pearson", "kendall", "spearman"),
  ...
)

\method{cor}{symbolic_tbl}(x, ...)

\method{cor}{symbolic_interval}(x, y, method = c("centers", "B", "BD", "BG"), ...)
}
\arguments{
\item{x}{First symbolic variables.}

\item{...}{As in R cor function.}

\item{y}{Second symbolic variables.}

\item{use}{an optional character string giving a method for computing
correlation in the presence of missing values. This must be (an abbreviation of)
 one of the strings 'everything', 'all.obs', 'complete.obs', 'na.or.complete',
 or 'pairwise.complete.obs'.}

\item{method}{The method to be use.}
}
\value{
Return a real number.
}
\description{
This function compute the symbolic correlation
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{correlation}
