% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_ridgeplot.R
\name{pathway_ridgeplot}
\alias{pathway_ridgeplot}
\title{Ridge Plot for GSEA Results}
\usage{
pathway_ridgeplot(
  gsea_results,
  abundance,
  metadata,
  group,
  pathway_reference = NULL,
  pathway_type = "KEGG",
  n_pathways = 10,
  sort_by = "p.adjust",
  show_direction = TRUE,
  colors = c(Down = "#3182bd", Up = "#de2d26"),
  title = "Ridge Plot: Gene Distribution in Enriched Pathways",
  x_lab = "log2 Fold Change",
  scale_height = 0.9,
  alpha = 0.7
)
}
\arguments{
\item{gsea_results}{A data frame containing GSEA results from \code{\link{pathway_gsea}}.
Must contain pathway_id column and either NES or direction column.}

\item{abundance}{A data frame or matrix containing the original abundance data
(genes/KOs as rows, samples as columns) used in the GSEA analysis.}

\item{metadata}{A data frame containing sample metadata with group information.}

\item{group}{Character string specifying the column name in metadata for grouping.}

\item{pathway_reference}{A data frame containing pathway-to-gene mappings.
Must have columns: pathway_id (or go_id for GO) and a column containing
gene/KO members (semicolon-separated). If NULL, attempts to use built-in
KEGG or GO reference data.}

\item{pathway_type}{Character string specifying the pathway type: "KEGG", "GO", or "MetaCyc".
Default is "KEGG".}

\item{n_pathways}{Integer specifying the number of top pathways to display.
Default is 10.}

\item{sort_by}{Character string specifying how to sort pathways:
"NES" (Normalized Enrichment Score), "pvalue", or "p.adjust".
Default is "p.adjust".}

\item{show_direction}{Logical. If TRUE, colors ridges by enrichment direction.
Default is TRUE.}

\item{colors}{Named character vector with colors for "Up" and "Down" directions.
Default is blue for down-regulated and red for up-regulated.}

\item{title}{Character string for plot title.}

\item{x_lab}{Character string for x-axis label.}

\item{scale_height}{Numeric value controlling the overlap of ridges.
Default is 0.9. Higher values create more overlap.}

\item{alpha}{Numeric value for ridge transparency (0-1). Default is 0.7.}
}
\value{
A ggplot2 object that can be further customized or saved.
}
\description{
Creates a ridge plot (joy plot) to visualize the distribution of gene/KO
abundances or fold changes for enriched pathways from GSEA analysis.
This helps interpret whether pathways are predominantly up- or down-regulated.
}
\details{
The ridge plot displays the distribution of gene abundances (or fold changes)
for genes within each enriched pathway. This visualization helps to:
\itemize{
  \item Understand the overall direction of change for each pathway
  \item Identify pathways with consistent vs. heterogeneous gene expression
  \item Compare the magnitude of changes across pathways
}

The plot requires the \code{ggridges} package to be installed.
}
\examples{
\dontrun{
library(ggpicrust2)
library(tibble)

# Load example data
data("ko_abundance")
data("metadata")

# Run GSEA (using camera method - recommended)
gsea_results <- pathway_gsea(
  abundance = ko_abundance \%>\% column_to_rownames("#NAME"),
  metadata = metadata,
  group = "Environment",
  pathway_type = "KEGG",
  method = "camera"
)

# Create ridge plot
ridge_plot <- pathway_ridgeplot(
  gsea_results = gsea_results,
  abundance = ko_abundance \%>\% column_to_rownames("#NAME"),
  metadata = metadata,
  group = "Environment",
  n_pathways = 10
)
print(ridge_plot)
}

}
\seealso{
\code{\link{pathway_gsea}}, \code{\link{visualize_gsea}},
  \code{\link{pathway_volcano}}
}
