% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lollipop.R
\name{plot_lollipop}
\alias{plot_lollipop}
\title{Lollipop plot of variants along a gene}
\usage{
plot_lollipop(
  variants,
  gene = NULL,
  domains = NULL,
  color_by = "consequence",
  palette = NULL,
  protein_length = NULL,
  stack_dots = TRUE,
  title = NULL,
  interactive = FALSE
)
}
\arguments{
\item{variants}{A \code{gvf} object from \code{\link[=read_vcf]{read_vcf()}} or \code{\link[=coerce_variants]{coerce_variants()}},
or any \code{data.frame} with columns \code{pos}, \code{consequence}, and optionally
\code{gene} and \code{sample}.}

\item{gene}{Character. Gene to filter on. If \code{NULL} and \code{variants} contains
a \code{gene} column, the most-mutated gene is chosen automatically.}

\item{domains}{A \code{data.frame} with columns \code{name}, \code{start}, \code{end} (amino
acid positions) for domain annotation. \code{NULL} (default) omits domains.}

\item{color_by}{Column name to use for dot colour. Default \code{"consequence"}.
Set to \code{"sample"} to colour by sample instead.}

\item{palette}{Named character vector of colours for each consequence/sample
category. \code{NULL} uses the built-in \code{ggvariant} palette.}

\item{protein_length}{Integer. Total length of the protein in amino acids,
used to scale the x-axis. If \code{NULL}, inferred from \code{max(pos)}.}

\item{stack_dots}{Logical. If \code{TRUE} (default), dots at the same position
are stacked vertically (beeswarm-style) rather than overlapping.}

\item{title}{Character. Plot title. Defaults to the gene name.}

\item{interactive}{Logical. If \code{TRUE}, returns a \code{plotly} interactive plot
(requires the \code{plotly} package).}
}
\value{
A \code{ggplot} object (or a \code{plotly} object when \code{interactive = TRUE}).
}
\description{
Draws a lollipop (stem-and-dot) diagram showing variant positions along
a gene, coloured by consequence. Optionally overlays protein domain
annotations when domain boundaries are supplied.
}
\examples{
vcf_file <- system.file("extdata", "example.vcf", package = "ggvariant")
variants <- read_vcf(vcf_file)

# Basic lollipop for the most-mutated gene
plot_lollipop(variants)

# Specific gene
plot_lollipop(variants, gene = "TP53")

# With domain annotation
tp53_domains <- data.frame(
  name  = c("Transactivation", "DNA-binding", "Tetramerization"),
  start = c(1, 102, 323),
  end   = c(67, 292, 356)
)
plot_lollipop(variants, gene = "TP53", domains = tp53_domains)

}
