% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.decorana.R
\name{fortify.decorana}
\alias{fortify.decorana}
\alias{tidy.decorana}
\title{Fortify a \code{"decorana"} object.}
\usage{
\method{fortify}{decorana}(model, data, axes = 1:4, layers = c("sites", "species"), ...)

\method{tidy}{decorana}(x, data, axes = 1:4, layers = c("sites", "species"), ...)
}
\arguments{
\item{model, x}{an object of class \code{"decorana"}, the result of a call to
\code{\link[vegan:decorana]{vegan::decorana()}}.}

\item{data}{currently ignored.}

\item{axes}{numeric; which axis scores are required?}

\item{layers}{character; the scores to extract in the fortified object.}

\item{...}{additional arguments passed to \code{\link[vegan:decorana]{vegan::scores.decorana()}}.}
}
\value{
A data frame in long format containing the ordination scores. The
first two components are the axis scores.
}
\description{
Fortifies an object of class \code{"decorana"} to produce a data
frame of the selected axis scores in long format, suitable for plotting
with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)

sol <- decorana(dune)
head(fortify(sol))
head(fortify(sol, layers = "species"))
}
\author{
Gavin L. Simpson
}
