% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.renyiaccum.R
\name{fortify.renyiaccum}
\alias{fortify.renyiaccum}
\alias{tidy.renyiaccum}
\title{Fortify \enc{Rényi}{Renyi} accumulation curves}
\usage{
\method{fortify}{renyiaccum}(model, data, ...)

\method{tidy}{renyiaccum}(x, data, ...)
}
\arguments{
\item{model, x}{an object of class \code{\link[vegan:renyi]{vegan::renyiaccum()}}.}

\item{data}{original data set. Currently ignored.}

\item{...}{additional arguments passed to other methods. Ignored in this
method.}
}
\value{
A data frame (tibble) is returned. What is returned depends on how
\code{\link[vegan:renyi]{vegan::renyiaccum()}} was called.
If \code{raw = FALSE}, then a data frame with columns \code{site}, \code{scale}, \code{mean},
\code{std_dev}, \code{min}, \code{max}, \code{q2.5}, and \code{q97.5}, containing the accumulated
sites, the \enc{Rényi}{Renyi} scale, and summary statistics of the
\enc{Rényi}{Renyi} accumulation curves. An additional column \code{collector}
will be present if \code{collector = TRUE} was used in the \code{\link[vegan:renyi]{vegan::renyiaccum()}}
call.
If \code{raw = TRUE}, then a data frame with columns \code{site}, \code{permutation},
\code{scale}, and \code{diversity}, containing the \code{site} and \code{permutation}
identifiers, \enc{Rényi}{Renyi} scale, and the \enc{Rényi}{Renyi}
diversity, respectively.
}
\description{
Prepares a fortified version of results from
\code{\link[vegan:renyi]{vegan::renyiaccum()}} objects.
}
\examples{

library("vegan")
library("ggplot2")
data(BCI)
pool <- renyiaccum(BCI)
df <- fortify(pool)
df

ggplot(df, aes(x = site, y = mean)) +
    geom_ribbon(aes(ymin = q2.5, ymax = q97.5, x = site),
                alpha = 0.2, inherit.aes = FALSE) +
    geom_line() +
    facet_wrap(~ scale)
}
\author{
Gavin L. Simpson much rewritten from an original by Didzis Elferts.
}
