% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gipsmult_class.R
\name{print.gipsmult}
\alias{print.gipsmult}
\title{Printing \code{gipsmult} object}
\usage{
\method{print}{gipsmult}(
  x,
  digits = 3,
  compare_to_original = TRUE,
  log_value = FALSE,
  oneline = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of a \code{gipsmult} class.}

\item{digits}{The number of digits after the comma
for a posteriori to be presented. It can be negative.
By default, \code{Inf}. It is passed to \code{\link[base:Round]{base::round()}}.}

\item{compare_to_original}{A logical. Whether to print how many
times more likely is the current permutation compared to:
\itemize{
\item the identity permutation \verb{()} (for unoptimized \code{gipsmult} object);
\item the starting permutation (for optimized \code{gipsmult} object).
}}

\item{log_value}{A logical. Whether to print the logarithmic value.
Default to \code{FALSE}.}

\item{oneline}{A logical. Whether to print in
one or multiple lines. Default to \code{FALSE}.}

\item{...}{The additional arguments passed to \code{\link[base:cat]{base::cat()}}.}
}
\value{
Returns an invisible \code{NULL}.
}
\description{
Printing function for a \code{gipsmult} class.
}
\examples{
Ss <- list(
  matrix(c(1, 0.5, 0.5, 2), nrow = 2, byrow = TRUE),
  matrix(c(2, 1, 3, 7), nrow = 2, byrow = TRUE)
)
noo <- c(10, 13)
g <- gipsmult(Ss, noo, perm = "(12)")
print(g, digits = 4, oneline = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=find_MAP]{find_MAP()}} - The function that makes
an optimized \code{gipsmult} object out of the unoptimized one.
}
}
