% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-utilities.R
\name{model_terms}
\alias{model_terms}
\alias{model_terms.gam}
\alias{model_terms.gamm}
\alias{model_terms.gamm4}
\alias{model_terms.lm}
\title{Find the names of model terms}
\usage{
model_terms(object, ...)

\method{model_terms}{gam}(object, ...)

\method{model_terms}{gamm}(object, ...)

\method{model_terms}{gamm4}(object, ...)

\method{model_terms}{lm}(object, ...)
}
\arguments{
\item{object}{a fitted model.}

\item{...}{arguments to be passed to other methods; not currently used.}
}
\value{
A character vector of model terms.
}
\description{
Returns the names of any terms in a model, without needing to call
\code{summary()}. The list of model terms is especially useful when predicting
from a \code{\link[mgcv:gam]{mgcv::gam()}} model using the \code{exclude} or \code{terms} argument of
\code{\link[mgcv:predict.gam]{mgcv::predict.gam()}} or \code{\link[mgcv:predict.bam]{mgcv::predict.bam()}}.
}
\details{
From the point of view of \emph{gratia}, models contain two types of term:
\enumerate{
\item parametric terms, and
\item smooth terms.
}

If we consider the formula \code{y ~ fac + s(x2, by = fac) + s(x0)}, for a factor
\code{fac} with three levels, there are seven terms in the model:
\enumerate{
\item the model constant term, with name \code{"(Intercept)"},
\item the parametric factor term, with names
\itemize{
\item \code{fac2},
\item \code{fac3},
}
\item the univariate smooth of \code{x0}, named \code{"s(x0)"}, and
\item the three factor-by smooths with names
\itemize{
\item \code{"s(x2):fac1"},
\item \code{"s(x2):fac2"}, and
\item \code{"s(x2):fac3"}.`
}
}

\code{model_terms()} will return a vector of those names.
}
\examples{
load_mgcv()

# simulate data
df <- data_sim("eg4", n = 400, dist = "normal", scale = 2, seed = 1)

# fit model
m <- gam(y ~ fac + s(x2, by = fac) + s(x0),
  data = df, method = "REML")

# return the names of terms in this model
model_terms(m)
}
