% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridify-classes.R
\docType{class}
\name{gridifyCell-class}
\alias{gridifyCell-class}
\title{gridifyCell class}
\description{
Class for creating a cell used in a gridify layout.
}
\section{Slots}{

\describe{
\item{\code{row}}{A numeric value, span or a sequence specifying the range of occupied rows of the cell.}

\item{\code{col}}{A numeric value, span or a sequence specifying the range of occupied columns of the cell.}

\item{\code{text}}{A character value specifying the default text for the cell.}

\item{\code{mch}}{A numeric value specifying the maximum number of characters per line.
The functionality is based on the \code{strwrap} function.
By default, it avoids breaking up words and only splits lines when specified.}

\item{\code{x}}{A numeric value specifying the x position of text in the cell.}

\item{\code{y}}{A numeric value specifying the y position of text in the cell.}

\item{\code{hjust}}{A numeric value specifying the horizontal position of the text in the cell, relative to the x value.}

\item{\code{vjust}}{A numeric value specifying the vertical position of the text in the cell, relative to the y value.}

\item{\code{rot}}{A numeric value specifying the rotation of the cell.}

\item{\code{gpar}}{A \code{grid::gpar()} object specifying the graphical parameters of the cell.}
}}

