% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo.R
\name{censo_populacao}
\alias{censo_populacao}
\title{Get Census population data}
\usage{
censo_populacao(
  year,
  variables = "total",
  territorial_level = "state",
  geo_code = "all",
  raw = FALSE
)
}
\arguments{
\item{year}{Numeric. Census year (1970, 1980, 1991, 2000, 2010, or 2022).}

\item{variables}{Character. Type of breakdown:
\itemize{
\item \code{"total"}: Total population only
\item \code{"sex"}: By sex (male/female)
\item \code{"age"}: By age groups
\item \code{"age_sex"}: By age groups and sex
\item \code{"race"}: By race/color (only 2000, 2010, 2022)
\item \code{"situation"}: By urban/rural situation
}
Default is \code{"total"}.}

\item{territorial_level}{Character. Geographic level:
\code{"brazil"}, \code{"region"}, \code{"state"}, or \code{"municipality"}.
Default is \code{"state"}.}

\item{geo_code}{Character. IBGE code(s) for specific localities.
\code{"all"} returns all localities at the chosen level. Default is \code{"all"}.}

\item{raw}{Logical. If TRUE, returns raw API output without cleaning.
Default is FALSE.}
}
\value{
A tibble with population data.
}
\description{
Retrieves population data from the Brazilian Demographic Census via SIDRA API.
Automatically selects the correct SIDRA table based on year and requested
variables.
}
\details{
This function provides an easy interface for the most common Census queries.
It automatically resolves the correct SIDRA table:
\itemize{
\item Table 200: Historical population 1970-2010 (by sex, age, situation)
\item Table 9514: Census 2022 population by sex and age
\item Table 136: Population by race 2000-2010
\item Table 9605: Population by race 2022
\item Table 9515: Population by urban/rural 2022
}

For more flexibility, use \code{\link{censo_sidra_data}} to query any table
with custom parameters.
}
\section{Data source}{

Data is retrieved from IBGE SIDRA API:
\verb{https://sidra.ibge.gov.br/}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# total population by state, 2022
censo_populacao(year = 2022)

# population by sex, Brazil level
censo_populacao(year = 2022, variables = "sex", territorial_level = "brazil")

# population by age and sex, 2010
censo_populacao(year = 2010, variables = "age_sex")

# population by race, 2022
censo_populacao(year = 2022, variables = "race")
\dontshow{\}) # examplesIf}
}
