% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinasc.R
\name{sinasc_variables}
\alias{sinasc_variables}
\title{List SINASC Variables}
\usage{
sinasc_variables(year = NULL, search = NULL)
}
\arguments{
\item{year}{Integer. If provided, returns variables available for that
specific year (reserved for future use). Default: NULL.}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive.}
}
\value{
A tibble with columns: variable, description, type, section.
}
\description{
Returns a tibble with available variables in the SINASC microdata,
including descriptions and value types.
}
\examples{
sinasc_variables()
sinasc_variables(search = "mae")
sinasc_variables(search = "parto")
}
\seealso{
Other sinasc: 
\code{\link{sinasc_cache_status}()},
\code{\link{sinasc_clear_cache}()},
\code{\link{sinasc_data}()},
\code{\link{sinasc_dictionary}()},
\code{\link{sinasc_info}()},
\code{\link{sinasc_years}()}
}
\concept{sinasc}
