% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{geom_flame}
\alias{geom_flame}
\title{Create 'flame' polygons.}
\usage{
geom_flame(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  n = 0,
  n_gap = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()} or \code{aes_()}.
If specified and inherit.aes = TRUE (the default), it is combined with the
default mapping at the top level of the plot. You must supply mapping if
there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three options:

If NULL, the default, the data is inherited from the plot data as specified
in the call to \code{ggplot()}.

A data.frame, or other object, will override the plot data. All objects will
be fortified to produce a data frame. See \code{fortify()} for which variables will
be created.

A function will be called with a single argument, the plot data. The return
value must be a \code{data.frame}, and will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a call
to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{linewidth = 3}. They may also be parameters
to the paired geom/stat.}

\item{n}{The number of steps along the x-axis (i.e. in a daily time series this
would be days) required before the area between \code{y} and \code{y2} will be
filled in. The default of 0 will fill in _all_ of the area between the lines.
The standard to match Hobday et al. (2016) is \code{n = 5}.}

\item{n_gap}{The number of steps along the x-axis (i.e. in a daily time series this
would be days) within which to allow \code{geom_flame()} to connect polygons.
This is useful when one wants to not screen out parts of a polygon that dip
only briefly below \code{y} before coming back up above it. The defauly of 0
will not connect any of the polygons. The standard to match
Hobday et al. (2016) is \code{n_gap = 2}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{Logical. Should this layer be included in the legends? \code{NA},
the default, includes if any aesthetics are mapped. \code{FALSE} never includes, and
\code{TRUE} always includes. It can also be a named logical vector to finely select
the aesthetics to display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that define
both data and aesthetics and shouldn't inherit behaviour from the default plot
specification, e.g. \code{borders()}.}
}
\description{
This function will create polygons between two lines. If given a
temperature and threshold time series, like that produced by
\code{\link{detect_event}}, the output will meet the specifications
of Hobday et al. (2016) shown as 'flame polygons.' If one wishes to
plot polygons below a given threshold, and not above, switch the values
being fed to the \code{y} and \code{y2} aesthetics. This function differs
in use from \code{\link{event_line}} in that it must be created as a
\code{ggplot} 'geom' object. The benefit of this being that one may add
additional information to the figure as geom layers to ggplot2 graphs
as may be necessary.
}
\section{Aesthetics}{

\code{geom_flame} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \strong{\code{y2}}
  \item \code{colour}
  \item \code{fill}
  \item \code{linewidth}
  \item \code{alpha}
  \item \code{linetype}
}
}

\examples{
ts <- ts2clm(sst_WA, climatologyPeriod = c("1983-01-01", "2012-12-31"))
res <- detect_event(ts)
mhw <- res$clim
mhw <- mhw[10580:10690,]

library(ggplot2)

ggplot(mhw, aes(x = t, y = temp)) +
  geom_flame(aes(y2 = thresh)) +
  annotate(geom = "text", x = as.Date("2011-02-01"), y = 28,
           label = "That's not a heatwave.\nThis, is a heatwave.") +
  xlab("Date") + ylab(expression(paste("Temperature [", degree, "C]")))

}
\references{
Hobday, A.J. et al. (2016), A hierarchical approach to defining
marine heatwaves, Progress in Oceanography, 141, pp. 227-238,
doi: 10.1016/j.pocean.2015.12.014
}
\seealso{
\code{\link{event_line}} for a non-ggplot2 based flame function.
}
\author{
Robert W. Schlegel
}
