% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_id_merge.R
\name{model_id_merge}
\alias{model_id_merge}
\alias{model_id_split}
\title{Merge/Split model output tbl \code{model_id} column}
\usage{
model_id_merge(tbl, sep = "-")

model_id_split(tbl, sep = "-")
}
\arguments{
\item{tbl}{a \code{data.frame} or \code{tibble} of model output data returned from a query
to a \verb{<hub_connection>} object.}

\item{sep}{character string. Character used as separator when concatenating
\code{team_abbr} and \code{model_abbr} values into a single \code{model_id} string or splitting
\code{model_id} into component \code{team_abbr} and \code{model_abbr}. When splitting, if
multiple instances of the separator exist in a \code{model_id} stringing,
splitting occurs occurs on the first instance.}
}
\value{
\code{tbl} with either \code{team_abbr} and \code{model_abbr} merged into a single \code{model_id}
column or \code{model_id} split into columns \code{team_abbr} and \code{model_abbr}.

a \link[tibble:tibble]{tibble} with \code{model_id} column split into separate
\code{team_abbr} and \code{model_abbr} columns
}
\description{
Merge/Split model output tbl \code{model_id} column
}
\section{Functions}{
\itemize{
\item \code{model_id_merge()}: merge \code{team_abbr} and \code{model_abbr} into a single
\code{model_id} column.

\item \code{model_id_split()}: split \code{model_id} column into separate \code{team_abbr}
and \code{model_abbr} columns.

}}
\examples{
tbl_split <- model_id_split(hub_con_output)
tbl_split

# Merge model_id
tbl_merged <- model_id_merge(tbl_split)
tbl_merged

# Split / Merge using custom separator
tbl_sep <- hub_con_output
tbl_sep$model_id <- gsub("-", "_", tbl_sep$model_id)
tbl_sep <- model_id_split(tbl_sep, sep = "_")
tbl_sep
tbl_sep <- model_id_merge(tbl_sep, sep = "_")
tbl_sep
}
