% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feat.R
\name{subseries}
\alias{subseries}
\title{Seasonal Subseries Plots for inzightts}
\usage{
subseries(
  x,
  var = NULL,
  show_mean = TRUE,
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{x}{A time series object represented by an \code{inz_ts} or \code{tbl_ts} object.}

\item{var}{A character vector specifying the variable(s) to be plotted, or
set to \code{NULL} to plot all variables.}

\item{show_mean}{Logical; set to \code{FALSE} to exclude the mean line from the plot.}

\item{xlab}{A title for the x-axis of the plot.}

\item{ylab}{A title for the y-axis of the plot.}

\item{title}{A title for the graph.}
}
\value{
A ggplot object of the seasonal subseries plot.
}
\description{
Time series subseries plot by seasonal period
}
\details{
Plots seasonal subseries of a time series represented by an \code{inz_ts} or
\code{tbl_ts} object. Each subseries represents one seasonal period.
}
\examples{
t <- inzightts(visitorsQ)
\dontrun{
subseries(t)
}

}
\seealso{
\code{\link[ggtime]{gg_subseries}}
}
