% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinal.R
\name{compute_blup_eta}
\alias{compute_blup_eta}
\title{Compute BLUP-Based Latent Longitudinal Summaries}
\usage{
compute_blup_eta(lme_fits, patient_ids, times, markers = NULL)
}
\arguments{
\item{lme_fits}{Named list of \code{nlme::lme} objects (from \code{fit_longitudinal}).}

\item{patient_ids}{Numeric vector of patient IDs.}

\item{times}{Numeric vector of evaluation times.}

\item{markers}{Character vector of biomarker names. If \code{NULL}, uses
names of \code{lme_fits}.}
}
\value{
Data frame with columns \code{patient_id}, \code{time}, and one
\code{eta_*} column per biomarker.
}
\description{
Extracts subject-specific BLUPs from fitted \code{lme} models and computes
the latent trajectory \eqn{\eta_{ij}(t) = \hat\beta_{0j} + \hat b_{0ij} +
(\hat\beta_{1j} + \hat b_{1ij})t} at specified time points.
}
