% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancova_rbmi.R
\name{rbmi_ancova_single}
\alias{rbmi_ancova_single}
\title{Implements an Analysis of Covariance (ANCOVA)}
\usage{
rbmi_ancova_single(
  data,
  outcome,
  group,
  covariates,
  weights = c("counterfactual", "equal", "proportional_em", "proportional")
)
}
\arguments{
\item{data}{A \code{data.frame} containing the data to be used in the model.}

\item{outcome}{string, the name of the outcome variable in \code{data}.}

\item{group}{string, the name of the group variable in \code{data}.}

\item{covariates}{character vector containing the name of any additional covariates
to be included in the model as well as any interaction terms.}

\item{weights}{Character, either \code{"counterfactual"} (default), \code{"equal"},
\code{"proportional_em"} or \code{"proportional"}.
Specifies the weighting strategy to be used when calculating the lsmeans.
See the weighting section for more details.}
}
\value{
a list containing \code{var} with variance estimates as well as
\verb{trt_*} and \verb{lsm_*} entries. See \code{\link[=rbmi_ancova]{rbmi_ancova()}} for full details.
}
\description{
Performance analysis of covariance. See \code{\link[=rbmi_ancova]{rbmi_ancova()}} for full details.
}
\details{
\itemize{
\item \code{group} must be a factor variable with only 2 levels.
\item \code{outcome} must be a continuous numeric variable.
}
}
\examples{

 iris2 <- iris[iris$Species \%in\% c("versicolor", "virginica"), ]
 iris2$Species <- factor(iris2$Species)
 rbmi_ancova_single(iris2, "Sepal.Length", "Species", c("Petal.Length * Petal.Width"))


}
\seealso{
\code{\link[=rbmi_ancova]{rbmi_ancova()}}
}
