% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-training.R
\name{summary.keras.src.models.model.Model}
\alias{summary.keras.src.models.model.Model}
\alias{format.keras.src.models.model.Model}
\alias{print.keras.src.models.model.Model}
\title{Print a summary of a Keras Model}
\usage{
\method{summary}{keras.src.models.model.Model}(object, ...)

\method{format}{keras.src.models.model.Model}(
  x,
  line_length = min(getOption("width"), 180),
  positions = NULL,
  expand_nested = FALSE,
  show_trainable = NA,
  ...,
  layer_range = NULL,
  compact = TRUE
)

\method{print}{keras.src.models.model.Model}(x, ...)
}
\arguments{
\item{object, x}{Keras model instance}

\item{...}{for \code{summary()} and \code{print()}, passed on to \code{format()}. For
\code{format()}, passed on to \code{model$summary()}.}

\item{line_length}{Total length of printed lines}

\item{positions}{Relative or absolute positions of log elements in each line.
If not provided, defaults to \code{c(0.33, 0.55, 0.67, 1.0)}.}

\item{expand_nested}{Whether to expand the nested models. If not provided,
defaults to \code{FALSE}.}

\item{show_trainable}{Whether to show if a layer is trainable. If not
provided, defaults to \code{FALSE}.}

\item{layer_range}{a list, tuple, or vector of 2 strings,
which is the starting layer name and ending layer name
(both inclusive) indicating the range of layers to be printed
in summary. It also accepts regex patterns instead of exact
name. In such case, start predicate will be the first element
it matches to \code{layer_range[[1]]} and the end predicate will be
the last element it matches to \code{layer_range[[1]]}.
By default \code{NULL} which considers all layers of model.}

\item{compact}{Whether to remove white-space only lines from the model
summary. (Default \code{TRUE})}
}
\value{
\code{format()} returns a length 1 character vector. \code{print()} returns the
model object invisibly. \code{summary()} returns the output of \code{format()}
invisibly after printing it.
}
\description{
Print a summary of a Keras Model
}
\section{Enabling color output in Knitr (RMarkdown, Quarto)}{


In order to enable color output in a quarto or rmarkdown document with
an html output format (include revealjs presentations), then you will need
to do the following in a setup chunk:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ ```\{r setup, include = FALSE\}
 options(cli.num_colors = 256)
 fansi::set_knit_hooks(knitr::knit_hooks)
 options(width = 75) # adjust as needed for format
 ```
}\if{html}{\out{</div>}}
}

\seealso{
Other model functions: \cr
\code{\link{get_config}()} \cr
\code{\link{get_layer}()} \cr
\code{\link{get_state_tree}()} \cr
\code{\link{keras_model}()} \cr
\code{\link{keras_model_sequential}()} \cr
\code{\link{pop_layer}()} \cr
\code{\link{set_state_tree}()} \cr
}
\concept{model functions}
