% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_nfi.R
\name{diversity_nfi}
\alias{diversity_nfi}
\title{Calculate species diversity indices for National Forest Inventory Data}
\usage{
diversity_nfi(
  data,
  sp = "SP",
  table = "tree",
  basal = FALSE,
  byplot = FALSE,
  plotgrp = NULL,
  continuousplot = FALSE,
  clusterplot = FALSE,
  largetreearea = FALSE,
  stockedland = TRUE,
  talltree = TRUE
)
}
\arguments{
\item{data}{: A \code{list} generated by \code{\link{read_nfi}} that contains 'plot' and one of ('tree', 'herb', 'veg', 'sapling') data frames.}

\item{sp}{: A character vector; the column name of species information (e.g., "SP" for species, "GENUS" for genus-level analysis).}

\item{table}{: A character vector; Specifies which vegetation table to use for diversity analysis. Must be one of 'tree', 'herb', 'veg', 'sapling'.}

\item{basal}{: A logical flag (default FALSE); if TRUE, calculates tree diversity using basal area. If FALSE, uses number of individuals. Only applicable when \code{table = "tree"}.}

\item{byplot}{: A logical flag (default FALSE); if TRUE, calculates statistics for each plot separately. If FALSE, calculates for the entire dataset.}

\item{plotgrp}{: A character vector; specifies variables from 'plot' table to use for grouping. Use \code{c()} to combine multiple variables.}

\item{continuousplot}{: A logical flag (default TRUE); if TRUE, includes only plots that have been measured at the exact same location across all NFI cycles (5th, 6th, etc.). If FALSE, includes all plots regardless of location changes or missing cycle measurements.}

\item{clusterplot}{: A logical flag (default FALSE); if TRUE, treats each cluster plot as a single unit. If FALSE, calculates for each subplot separately.}

\item{largetreearea}{: A logical flag (default FALSE); if TRUE, includes large tree survey plots in the analysis. If FALSE, only uses standard tree plots.}

\item{stockedland}{: A logical flag (default TRUE); if TRUE, includes only stocked land. If FALSE, includes all land types.}

\item{talltree}{: A logical flag (default TRUE); if TRUE, includes only tall trees. If FALSE, includes both trees and shrubs.}
}
\value{
A \code{data.frame} that includes diversity indices.
The structure depends on the input parameters:
\itemize{
\item If \code{byplot = TRUE}, each row represents a plot.
\item If \code{byplot = FALSE}, each row represents the entire dataset or a group specified by \code{plotgrp}
}
}
\description{
diversity_nfi() function calculates species richness, evenness and the Shannon and Simpson diversity indices for National Forest Inventory (NFI) data.
It can provide diversity measures for individual plots, the entire study area, or specific groups within the study area using parameters \code{byplot} or \code{plotgrp}.
The function can calculate diversity at the species or genus level for different vegetation components (trees, herbs, vegetation, saplings).
It uses the \code{\link[vegan]{diversity}} function from the \pkg{vegan} package for core calculations.
Users have flexibility in specifying data inclusion criteria and analysis levels using parameters \code{clusterplot}, \code{largetreearea}, \code{stockedland}, and \code{talltree}.
These parameters determine whether to treat cluster plots as single plots, to include large tree survey plots, and to focus only on Stocked land and tall trees.
}
\details{
The function calculates the following diversity indices (mean and standard error):
\itemize{
\item Species richness: The total number of species surveyed.
\item Shannon-Wiener index: Calculated as the sum of the proportions of individuals or basal area of each species relative to the total.
\item Gini-Simpson index: Calculated as 1 minus Simpson's index. Ranges from 0 to 1, with higher values indicating greater diversity.
\item Species evenness: Calculated by dividing Shannon diversity by the natural logarithm of species richness.
Ranges from 0 to 1, with 1 indicating that all species are evenly distributed.
}
}
\note{
The 'herb', 'veg', and 'sapling' tables may contain a lot of errors, so use caution when interpreting results from these tables.
}
\examples{

data("nfi_donghae")

# Calculate tree diversity indices using basal area
tree_ba_diversity <- diversity_nfi(nfi_donghae, sp = "SP", table = "tree", 
                                    basal = TRUE, continuousplot = TRUE)

# Calculate tree diversity indices using number of individuals
tree_indi_diversity <- diversity_nfi(nfi_donghae, sp = "SP", table = "tree", 
                                      basal = FALSE, continuousplot = TRUE)

}
\references{
Shannon, C. E. (1948). A mathematical theory of communication. The Bell System Technical Journal, 27(3), 379–423.
Simpson, E. H. (1949). Measurement of diversity. Nature, 163(4148), 688–688.
Pielou, E. C. (1966). The measurement of diversity in different types of biological collections. Journal of Theoretical Biology, 13, 131–144.
}
\seealso{
\code{\link[vegan]{diversity}} for calculating the Shannon and Simpson diversity indices.
}
