% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_code.R
\name{extract_code}
\alias{extract_code}
\title{Generic function to extract code of any specified language}
\usage{
extract_code(input_string, language, case_sensitive = FALSE)
}
\arguments{
\item{input_string}{A string containing code blocks}

\item{language}{Language identifier(s) to extract (e.g., "r", "python", c("bash", "sh"))}

\item{case_sensitive}{Whether the language matching should be case-sensitive (default: FALSE)}
}
\value{
A character vector containing the extracted code
}
\description{
This function provides a flexible way to extract code blocks of any language
from a string by specifying the language identifier(s).
}
\examples{
# Extract R code
text <- "```r\nx <- 1:10\n```"
extract_code(text, "r")

# Extract multiple language variants
text <- "```bash\necho 'test'\n```\n```sh\nls -la\n```"
extract_code(text, c("bash", "sh"))

# Case-sensitive extraction
text <- "```R\nplot(1:10)\n```\n```r\nprint('hello')\n```"
extract_code(text, "r", case_sensitive = TRUE) # Only matches lowercase 'r'
extract_code(text, "r", case_sensitive = FALSE) # Matches both 'R' and 'r'

# Extract custom language
text <- "```julia\nprintln(\"Julia code\")\n```"
extract_code(text, "julia")

# Extract YAML configuration
config_text <- "
Here's the configuration:
```yaml
database:
  host: localhost
  port: 5432
  name: mydb
```
"
extract_code(config_text, "yaml")

# Extract multiple TypeScript and JavaScript blocks
mixed_text <- "
TypeScript:
```typescript
interface User {
    name: string;
    age: number;
}
```

JavaScript:
```js
const user = {name: 'John', age: 30};
```
"
# Extract TypeScript
extract_code(mixed_text, "typescript")
# Extract both TypeScript and JavaScript
extract_code(mixed_text, c("typescript", "js"))

}
