% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_client.R
\name{llm_ollama}
\alias{llm_ollama}
\title{Create Ollama LLM provider with enhanced availability check and auto-download}
\usage{
llm_ollama(
  base_url = "http://localhost:11434/api/chat",
  model = "qwen2.5:1.5b-instruct",
  temperature = 0.2,
  max_tokens = 5000,
  timeout = 100,
  stream = TRUE,
  verbose = TRUE,
  skip_test = FALSE,
  auto_download = TRUE,
  ...
)
}
\arguments{
\item{base_url}{The base URL for the Ollama API}

\item{model}{The model name to use}

\item{temperature}{The temperature parameter for response randomness}

\item{max_tokens}{Maximum number of tokens in response}

\item{timeout}{Request timeout in seconds}

\item{stream}{Whether to use streaming responses}

\item{verbose}{Whether to show verbose output}

\item{skip_test}{Whether to skip the availability test}

\item{auto_download}{Whether to automatically download missing models}

\item{...}{Additional parameters to pass to the model}
}
\value{
A configured LLM provider object
}
\description{
This function creates an Ollama LLM provider with better error handling
and follows tidyprompt best practices.
}
\author{
Zaoqu Liu; Email: liuzaoqu@163.com
}
