% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_point_layer_processor.R
\name{Ggplot2PointLayerProcessor}
\alias{Ggplot2PointLayerProcessor}
\title{Point Layer Processor}
\description{
Processes scatter plot layers (geom_point) to extract point data and generate selectors
for individual points in the SVG structure.
}
\keyword{Process}
\keyword{internal}
\keyword{layer}
\keyword{point}
\keyword{the}
\section{Super class}{
\code{\link[maidr:LayerProcessor]{maidr::LayerProcessor}} -> \code{Ggplot2PointLayerProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Ggplot2PointLayerProcessor-process}{\code{Ggplot2PointLayerProcessor$process()}}
\item \href{#method-Ggplot2PointLayerProcessor-extract_axes_labels}{\code{Ggplot2PointLayerProcessor$extract_axes_labels()}}
\item \href{#method-Ggplot2PointLayerProcessor-extract_data}{\code{Ggplot2PointLayerProcessor$extract_data()}}
\item \href{#method-Ggplot2PointLayerProcessor-generate_selectors}{\code{Ggplot2PointLayerProcessor$generate_selectors()}}
\item \href{#method-Ggplot2PointLayerProcessor-find_panel_grob}{\code{Ggplot2PointLayerProcessor$find_panel_grob()}}
\item \href{#method-Ggplot2PointLayerProcessor-find_children_by_type}{\code{Ggplot2PointLayerProcessor$find_children_by_type()}}
\item \href{#method-Ggplot2PointLayerProcessor-clone}{\code{Ggplot2PointLayerProcessor$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="apply_scale_mapping"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-apply_scale_mapping'><code>maidr::LayerProcessor$apply_scale_mapping()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="extract_layer_axes"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-extract_layer_axes'><code>maidr::LayerProcessor$extract_layer_axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_last_result'><code>maidr::LayerProcessor$get_last_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_layer_index"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_layer_index'><code>maidr::LayerProcessor$get_layer_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="initialize"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-initialize'><code>maidr::LayerProcessor$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="needs_reordering"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-needs_reordering'><code>maidr::LayerProcessor$needs_reordering()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="reorder_layer_data"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-reorder_layer_data'><code>maidr::LayerProcessor$reorder_layer_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="set_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-set_last_result'><code>maidr::LayerProcessor$set_last_result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-process"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$process(
  plot,
  layout,
  built = NULL,
  gt = NULL,
  scale_mapping = NULL,
  grob_id = NULL,
  panel_id = NULL,
  panel_ctx = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{layout}}{Layout information}

\item{\code{built}}{Built plot data (optional)}

\item{\code{gt}}{Gtable object (optional)}

\item{\code{scale_mapping}}{Scale mapping for faceted plots (optional)}

\item{\code{grob_id}}{Grob ID for faceted plots (optional)}

\item{\code{panel_id}}{Panel ID for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with data and selectors
Extract axis labels from the plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-extract_axes_labels"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-extract_axes_labels}{}}}
\subsection{Method \code{extract_axes_labels()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$extract_axes_labels(plot, built = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{built}}{Built plot data (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with x and y axis labels
Extract data from point layer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$extract_data(
  plot,
  built = NULL,
  scale_mapping = NULL,
  panel_id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{built}}{Built plot data (optional)}

\item{\code{scale_mapping}}{Scale mapping for faceted plots (optional)}

\item{\code{panel_id}}{Panel ID for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with points array and color information
Generate selectors for point elements
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-generate_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-generate_selectors}{}}}
\subsection{Method \code{generate_selectors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$generate_selectors(
  plot,
  gt = NULL,
  grob_id = NULL,
  panel_ctx = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{gt}}{Gtable object (optional)}

\item{\code{grob_id}}{Grob ID for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of selectors
Find the main panel grob
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-find_panel_grob"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-find_panel_grob}{}}}
\subsection{Method \code{find_panel_grob()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$find_panel_grob(gt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gt}}{The gtable to search}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The panel grob or NULL
Find children by type pattern
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-find_children_by_type"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-find_children_by_type}{}}}
\subsection{Method \code{find_children_by_type()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$find_children_by_type(grob, type_pattern)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grob}}{The grob to search}

\item{\code{type_pattern}}{Pattern to match}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of matching children
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PointLayerProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PointLayerProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PointLayerProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
