% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predictions.R
\name{plot_predictions}
\alias{plot_predictions}
\title{Plot Conditional or Marginal Predictions}
\usage{
plot_predictions(
  model,
  condition = NULL,
  by = NULL,
  newdata = NULL,
  type = NULL,
  vcov = NULL,
  conf_level = 0.95,
  wts = FALSE,
  transform = NULL,
  points = 0,
  rug = FALSE,
  gray = getOption("marginaleffects_plot_gray", default = FALSE),
  draw = TRUE,
  ...
)
}
\arguments{
\item{model}{Model object}

\item{condition}{Conditional predictions.
\itemize{
\item Character vector (max length 4): Names of the predictors to display.
\item Named list (max length 4): List names correspond to predictors. List elements can be:
\itemize{
\item Numeric vector
\item Function which returns a numeric vector or a set of unique categorical values
\item Shortcut strings for common reference values: "minmax", "quartile", "threenum"
}
\item 1: x-axis. 2: color/shape. 3: facet (wrap if no fourth variable, otherwise cols of grid). 4: facet (rows of grid).
\item Numeric variables in positions 2 and 3 are summarized by Tukey's five numbers \code{?stats::fivenum}
}}

\item{by}{Marginal predictions
\itemize{
\item Character vector (max length 3): Names of the categorical predictors to marginalize across.
\item 1: x-axis. 2: color. 3: facets.
}}

\item{newdata}{When \code{newdata} is \code{NULL}, the grid is determined by the \code{condition} argument. When \code{newdata} is not \code{NULL}, the argument behaves in the same way as in the \code{predictions()} function. Note that the \code{condition} argument builds its own grid, so the \code{newdata} argument is ignored if the \code{condition} argument is supplied.}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
first entry in the error message is used by default. See the Type section in the documentation below.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
\item "rsample", "boot", "fwb", and "simulation" are passed to the \code{method} argument of the \code{inferences()} function. To customize the bootstrap or simulation process, call \code{inferences()} directly.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{wts}{logical, string or numeric: weights to use when computing average predictions, contrasts or slopes. These weights only affect the averaging in \verb{avg_*()} or with the \code{by} argument, and not unit-level estimates. See \code{?weighted.mean}
\itemize{
\item string: column name of the weights variable in \code{newdata}. When supplying a column name to \code{wts}, it is recommended to supply the original data (including the weights variable) explicitly to \code{newdata}.
\item numeric: vector of length equal to the number of rows in the original data or in \code{newdata} (if supplied).
\item FALSE: Equal weights.
\item TRUE: Extract weights from the fitted object with \code{insight::find_weights()} and use them when taking weighted averages of estimates. Warning: \code{newdata=datagrid()} returns a single average weight, which is equivalent to using \code{wts=FALSE}
}}

\item{transform}{A function applied to unit-level adjusted predictions and confidence intervals just before the function returns results. For bayesian models, this function is applied to individual draws from the posterior distribution, before computing summaries.}

\item{points}{Number between 0 and 1 which controls the transparency of raw data points. 0 (default) does not display any points. Warning: The points displayed are raw data, so the resulting plot is not a "partial residual plot."}

\item{rug}{TRUE displays tick marks on the axes to mark the distribution of raw data.}

\item{gray}{FALSE grayscale or color plot}

\item{draw}{\code{TRUE} returns a \code{ggplot2} plot. \code{FALSE} returns a \code{data.frame} of the underlying data.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?slopes} documentation for a non-exhaustive list of available
arguments.}
}
\value{
A \code{ggplot2} object or data frame (if \code{draw=FALSE})
}
\description{
Plot predictions on the y-axis against values of one or more predictors (x-axis, colors/shapes, and facets).

The \code{by} argument is used to plot marginal predictions, that is, predictions made on the original data, but averaged by subgroups. This is analogous to using the \code{by} argument in the \code{predictions()} function.

The \code{condition} argument is used to plot conditional predictions, that is, predictions made on a user-specified grid. This is analogous to using the \code{newdata} argument and \code{datagrid()} function in a \code{predictions()} call. All variables whose values are not specified explicitly are treated as usual by \code{datagrid()}, that is, they are held at their mean or mode (or rounded mean for integers). This includes grouping variables in mixed-effects models, so analysts who fit such models may want to specify the groups of interest using the \code{condition} argument, or supply model-specific arguments to compute population-level estimates. See details below.

See the "Plots" vignette and website for tutorials and information on how to customize plots:
\itemize{
\item https://marginaleffects.com/bonus/plot.html
\item https://marginaleffects.com
}
}
\section{Model-Specific Arguments}{


Some model types allow model-specific arguments to modify the nature of
marginal effects, predictions, marginal means, and contrasts. Please report
other package-specific \code{predict()} arguments on Github so we can add them to
the table below.

https://github.com/vincentarelbundock/marginaleffects/issues\tabular{llll}{
   Package \tab Class \tab Argument \tab Documentation \cr
   \code{brms} \tab \code{brmsfit} \tab \code{ndraws} \tab \link[brms:posterior_predict.brmsfit]{brms::posterior_predict} \cr
    \tab  \tab \code{re_formula} \tab \link[brms:posterior_predict.brmsfit]{brms::posterior_predict} \cr
   \code{lme4} \tab \code{merMod} \tab \code{re.form} \tab \link[lme4:predict.merMod]{lme4::predict.merMod} \cr
    \tab  \tab \code{allow.new.levels} \tab \link[lme4:predict.merMod]{lme4::predict.merMod} \cr
   \code{glmmTMB} \tab \code{glmmTMB} \tab \code{re.form} \tab \link[glmmTMB:predict.glmmTMB]{glmmTMB::predict.glmmTMB} \cr
    \tab  \tab \code{allow.new.levels} \tab \link[glmmTMB:predict.glmmTMB]{glmmTMB::predict.glmmTMB} \cr
    \tab  \tab \code{zitype} \tab \link[glmmTMB:predict.glmmTMB]{glmmTMB::predict.glmmTMB} \cr
   \code{mgcv} \tab \code{bam} \tab \code{exclude} \tab \link[mgcv:predict.bam]{mgcv::predict.bam} \cr
    \tab \code{gam} \tab \code{exclude} \tab \link[mgcv:predict.gam]{mgcv::predict.gam} \cr
   \code{robustlmm} \tab \code{rlmerMod} \tab \code{re.form} \tab \link[robustlmm:rlmerMod-class]{robustlmm::predict.rlmerMod} \cr
    \tab  \tab \code{allow.new.levels} \tab \link[robustlmm:rlmerMod-class]{robustlmm::predict.rlmerMod} \cr
   \code{MCMCglmm} \tab \code{MCMCglmm} \tab \code{ndraws} \tab  \cr
   \code{sampleSelection} \tab \code{selection} \tab \code{part} \tab \link[sampleSelection:predict.selection]{sampleSelection::predict.selection} \cr
}
}

\section{Types}{


The \code{type} argument determines the scale of the predictions used to compute quantities of interest with functions from the \code{marginaleffects} package. Admissible values for \code{type} depend on the model object. When users specify an incorrect value for \code{type}, \code{marginaleffects} will raise an informative error with a list of valid \code{type} values for the specific model object. The first entry in the list in that error message is the default type.

The \code{invlink(link)} is a special type defined by \code{marginaleffects}. It is available for some (but not all) models, and only for the \code{predictions()} function. With this link type, we first compute predictions on the link scale, then we use the inverse link function to backtransform the predictions to the response scale. This is useful for models with non-linear link functions as it can ensure that confidence intervals stay within desirable bounds, ex: 0 to 1 for a logit model. Note that an average of estimates with \code{type="invlink(link)"} will not always be equivalent to the average of estimates with \code{type="response"}. This type is default when calling \code{predictions()}. It is available---but not default---when calling \code{avg_predictions()} or \code{predictions()} with the \code{by} argument.

Some of the most common \code{type} values are:\tabular{ll}{
   class \tab type \cr
   DirichletRegModel \tab response \cr
   Gam \tab invlink(link), response, link \cr
   Gls \tab lp \cr
   MCMCglmm \tab response \cr
   bam \tab response, link \cr
   bart \tab ev, ppd \cr
   betareg \tab response, link, precision, quantile, variance \cr
   bife \tab response, link \cr
   bracl \tab probs \cr
   brglmFit \tab response, link \cr
   brmsfit \tab response, link, prediction, average \cr
   brmultinom \tab probs, class \cr
   clm \tab prob, cum.prob, linear.predictor \cr
   clogit \tab expected, lp, risk, survival \cr
   coxph \tab survival, expected, lp, risk \cr
   coxph_weightit \tab survival, expected, lp, risk \cr
   crch \tab response, location, scale, density \cr
   fixest \tab invlink(link), response, link \cr
   flexsurvreg \tab survival, response, mean, link, lp, linear, rmst, hazard, cumhaz \cr
   gam \tab response, link \cr
   geeglm \tab response, link \cr
   glimML \tab response, link \cr
   glm \tab invlink(link), response, link \cr
   glm_weightit \tab invlink(link), probs, response, lp, link \cr
   glmerMod \tab response, link \cr
   glmgee \tab response \cr
   glmmPQL \tab response, link \cr
   glmmTMB \tab response, link, conditional, zprob, zlink, disp \cr
   glmrob \tab response, link \cr
   glmx \tab response \cr
   hetprob \tab pr, xb \cr
   hurdle \tab response, prob, count, zero \cr
   hxlr \tab location, cumprob, scale, density \cr
   iv_robust \tab response \cr
   ivpml \tab pr, xb \cr
   ivreg \tab response \cr
   lda \tab class, posterior \cr
   lm \tab response \cr
   lm_robust \tab response \cr
   lmerMod \tab response \cr
   lmerModLmerTest \tab response \cr
   lmrob \tab response \cr
   lrm \tab fitted, lp, mean \cr
   mblogit \tab response, latent, link \cr
   mclogit \tab response, latent, link \cr
   mhurdle \tab E, Ep, p \cr
   model_fit \tab numeric, prob, class \cr
   multinom \tab probs, latent \cr
   multinom_weightit \tab probs, response, mean \cr
   mvgam \tab response, link, expected, detection, latent_N \cr
   negbin \tab invlink(link), response, link \cr
   ols \tab lp \cr
   oohbchoice \tab probability, utility \cr
   ordinal_weightit \tab probs, response, link, lp, mean \cr
   orm \tab fitted, mean, lp \cr
   polr \tab probs \cr
   rendo.base \tab response, link \cr
   rlm \tab response \cr
   selection \tab response, link, unconditional, conditional \cr
   speedglm \tab response, link \cr
   speedlm \tab response \cr
   stanreg \tab response, link \cr
   survreg \tab response, link, quantile \cr
   svyglm \tab response, link \cr
   svyolr \tab probs \cr
   tobit \tab response, link \cr
   tobit1 \tab expvalue, linpred, prob \cr
   workflow \tab numeric, prob, class \cr
   zeroinfl \tab response, prob, count, zero \cr
}
}

\examples{
\dontshow{if (interactive() || isTRUE(Sys.getenv("R_DOC_BUILD") == "true")) withAutoprint(\{ # examplesIf}
mod <- lm(mpg ~ hp + wt, data = mtcars)
plot_predictions(mod, condition = "wt")

mod <- lm(mpg ~ hp * wt * am, data = mtcars)
plot_predictions(mod, condition = c("hp", "wt"))

plot_predictions(mod, condition = list("hp", wt = "threenum"))

plot_predictions(mod, condition = list("hp", wt = range))

# marginal predictions
mod <- lm(mpg ~ hp * am, data = mtcars)
plot_predictions(mod, by = "am")

# marginal predictions on a counterfactual grid
plot_predictions(mod,
    by = "am",
    newdata = datagrid(am = 0:1, grid_type = "counterfactual")
)
\dontshow{\}) # examplesIf}
}
