% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMemory.R
\name{plotMemory}
\alias{plotMemory}
\title{Plots output of \code{\link{computeMemory}}}
\usage{
plotMemory(
  memory.output = NULL,
  ribbon = FALSE,
  legend.position = "right",
  ...
)
}
\arguments{
\item{memory.output}{list, output of \code{\link{computeMemory}}. Default: \code{NULL}.}

\item{ribbon}{logical, switches plotting of confidence intervals on (TRUE) and off (FALSE). Default: \code{FALSE}.}

\item{legend.position}{character, position of the legend. Default: \code{"right"}.}

\item{...}{additional arguments for internal use.}
}
\value{
A ggplot object.
}
\description{
Plots the ecological memory pattern yielded by \code{\link{computeMemory}}.
}
\examples{
#loading data
data(palaeodataMemory)

#plotting memory pattern
plotMemory(memory.output = palaeodataMemory)

#with confidence ribbon
plotMemory(memory.output = palaeodataMemory, ribbon = TRUE)

}
\seealso{
\code{\link{computeMemory}}

Other memoria: 
\code{\link{computeMemory}()},
\code{\link{extractMemoryFeatures}()}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
\concept{memoria}
