% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaDeconfound.R
\name{MetaDeconfound}
\alias{MetaDeconfound}
\title{MetaDeconfound}
\usage{
MetaDeconfound(
  featureMat,
  metaMat,
  nnodes = 1,
  adjustMethod = "fdr",
  adjustLevel = NULL,
  robustCutoff = 5,
  QCutoff = 0.1,
  DCutoff = 0,
  PHS_cutoff = 0.05,
  logfile = NULL,
  logLevel = "INFO",
  startStop = NA,
  QValues = NA,
  DValues = NA,
  minQValues = NULL,
  deconfT = NULL,
  deconfF = NULL,
  doConfs = 2,
  doRanks = NA,
  randomVar = NA,
  fixedVar = NA,
  robustCutoffRho = NULL,
  typeCategorical = NULL,
  typeContinuous = NULL,
  logistic = FALSE,
  rawCounts = FALSE,
  returnLong = FALSE,
  collectMods = FALSE,
  mediationMat = NULL,
  noConfConfs = TRUE,
  ...
)
}
\arguments{
\item{featureMat}{a data frame with row(sample ID)
and column(feature such as metabolite or microbial OTU )
names, listing features for all samples}

\item{metaMat}{a data frame with row(sample ID) and
column(meta data such as age,BMI and all possible confounders)
names listing metadata for all samples. The first column should be a binary
status/outcome variable (e.g. case=1 and control=0).
All other binary variables need to be in 0/1 syntax as well.}

\item{nnodes}{number of nodes/cores to be used for parallel processing}

\item{adjustMethod}{multiple testing p-value correction using one of the
methods of \link[stats]{p.adjust.methods}}

\item{adjustLevel}{1 = correction for number of features (default);
2 = correction for number of features AND number of metavariables;
3 = correction for number of features AND number of variables in mediationMat
(default when mediationMat is supplied)}

\item{robustCutoff}{minimal number of sample size for each covariate
in order to have sufficient power for association testing}

\item{QCutoff}{significance cutoff for q-value, DEFAULT = 0.1}

\item{DCutoff}{effect size cutoff
(either Cliff's Delta or Spearman's rho), DEFAULT = 0}

\item{PHS_cutoff}{PostHoc Significance cutoff}

\item{logfile}{name of optional logging file.}

\item{logLevel}{logging verbosity, possible levels:
TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF,  DEFAULT = INFO}

\item{startStop}{vector of optional strings controlling which
parts of the pipeline should be executed.
("naiveStop": only naive associations will be computed, no confounder analysis is done)}

\item{QValues}{optional data.frame containing pre-computed multiple-testing corrected p-values for naive associations}

\item{DValues}{optional data.frame containing pre-computed effect sizes for naive associations}

\item{minQValues}{pessimistic qvalues, can be generated by
\link[metadeconfoundR]{ImportLongPrior}.
This dataframe of QValues is used to incorporate prior knowledge of
potential associations between individual features and metadata by supplying
QValues < QCutoff for these associations. All significant associations thus
reported will be treated as potentially confounding influences.}

\item{deconfT}{vector of metavariable names *always* to be included as potential confounder}

\item{deconfF}{vector of metavariable names *never* to be included as potential confounder}

\item{doConfs}{optional parameter for additional computation of confidence
interval of linear models in the deconfounding step. level:
(0 = no , 1 = logging, 2 = strict (default))}

\item{doRanks}{optional vector of metavariable names, that should be rank
transformed when building linear models in the doconfounding step}

\item{randomVar}{optional vector of metavariable names to be treated as
random effect variables. These variables will not be tested for naive
associations and will not be included as potential confounders,
but will be added as random effects "+ (1|variable)" into any models being built.
Any associations reducible to the supplied random effect(s) will be labeled
 as "NS". Note: Ps, Qs, Ds are computed independently and thereby not changed
 through inclusion of random effects.}

\item{fixedVar}{optional vector of metavariable names to be treated as
fixed effect variables. These variabels will not be tested for naive
associations and will not be included as potential confounders,
but will be added as fixed effects "+ variable" into any models being built.
Any associations reducible to the supplied fixed effect(s) will be labeled
as "NS". Note: Ps, Qs, Ds are computed independently and thereby not changed
through inclusion of fixed effects.}

\item{robustCutoffRho}{optional robustness cutoff for continuous variables}

\item{typeCategorical}{optional character vector of metavariable names to
always be treated as categorical}

\item{typeContinuous}{optional character vector of metavariable names to
always be treated as continuous}

\item{logistic}{optional logical parameter; DEFAULT = FALSE;
Set TRUE to treat supplied features as binary instead of continuous}

\item{rawCounts}{optional logical parameter; DEFAULT = FALSE;
Set TRUE to treat supplied features as not normalized/rarefied counts;
metadeconfoundR will compute total read count per sample and include this
information in the modelling steps. WARNING: naive associations in
first part of metadeconfoundR are computed on TSS-transformed version of input data.}

\item{returnLong}{DEFAULT = FALSE; Set TRUE to get output in one long
format data.frame instead of list of four wide format data.frames}

\item{collectMods}{DEFAULT = FALSE; Set TRUE to collect all model objects
generated by Metadeconfound and return them in a nested list alongside the
standard Ps/Qs/Ds/status output.}

\item{mediationMat}{optional additional data frame for mediation analysis
with row(sample ID) and column(feature such as metabolite or microbial
OTU ) names. Features supplied here will be tested for associations in
featureMat, and confounder controlled for variables in metaMat.}

\item{noConfConfs}{DEFAULT = TRUE; Set FALSE if confounders that are
themselves confounded by other variables should be kept in the list of
confounders in the status label of affected associations.}

\item{...}{for additional arguments used internally (development/debugging)}
}
\value{
list with elements (or data.frame with columns, when returnLong = TRUE) Ds = effectsize,
Ps = uncorrected p-value for naive association,
Qs = multiple testing corrected p-value/fdr,
and status = confounding status for all
feature <=> covariate combinations with following categories:
(NS = not significant, OK_sd = strictly deconfounded, OK_nc = no covariates,
OK_d = doubtful, AD = ambiguously deconfounded, C: followed by comma
separated covariate names = confounded by listed covariates)\cr

Can be plotted using \link[metadeconfoundR]{BuildHeatmap}.
}
\description{
MetaDeconfound checks all feature <-> covariate combinations for
counfounding effects of covariates on feature <-> effect correlation
}
\details{
for more details and explanations please see the vignette.
}
\examples{
data(reduced_feature)
data(metaMatMetformin)
\donttest{
example_output <- MetaDeconfound(featureMat = reduced_feature,
                                  metaMat = metaMatMetformin,
                                  logLevel = "ERROR")
}

}
