% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{cat_design}
\alias{cat_design}
\title{Display survey design information}
\usage{
cat_design(self)
}
\arguments{
\item{self}{Survey object containing design information}
}
\value{
Invisibly returns NULL; called for side
effect of printing design info
}
\description{
Pretty-prints the sampling design configuration for each estimation type
in a Survey object, showing PSU, strata, weights, and other design elements
in a color-coded, readable format.
}
\details{
This function displays design information including:
\itemize{
\item Primary Sampling Units (PSU/clusters)
\item Stratification variables
\item Weight variables for each estimation type
\item Finite Population Correction (FPC) if used
\item Calibration formulas if applied
\item Overall design type classification
}

Output is color-coded for better readability in supporting terminals.
}
\examples{
\donttest{
dt <- data.table::data.table(id = 1:20, x = rnorm(20), w = runif(20, 0.5, 2))
svy <- Survey$new(
  data = dt, edition = "2023", type = "demo",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
cat_design(svy)
}

}
\seealso{
\code{\link{cat_design_type}} for design type classification

Other survey-objects: 
\code{\link{Survey}},
\code{\link{cat_design_type}()},
\code{\link{get_data}()},
\code{\link{get_metadata}()},
\code{\link{has_design}()},
\code{\link{has_recipes}()},
\code{\link{has_steps}()},
\code{\link{is_baked}()},
\code{\link{set_data}()},
\code{\link{survey_empty}()},
\code{\link{survey_to_data_frame}()},
\code{\link{survey_to_datatable}()},
\code{\link{survey_to_tibble}()}
}
\concept{survey-objects}
