% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{get_data}
\alias{get_data}
\title{get_data}
\usage{
get_data(svy)
}
\arguments{
\item{svy}{Survey object}
}
\value{
A \code{data.table} (or \code{data.frame}) containing the survey microdata.
}
\description{
Get data from survey
}
\examples{
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60),
  w = rep(1, 5)
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "ech",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
head(get_data(svy))
}
\seealso{
Other survey-objects: 
\code{\link{Survey}},
\code{\link{cat_design}()},
\code{\link{cat_design_type}()},
\code{\link{get_metadata}()},
\code{\link{has_design}()},
\code{\link{has_recipes}()},
\code{\link{has_steps}()},
\code{\link{is_baked}()},
\code{\link{set_data}()},
\code{\link{survey_empty}()},
\code{\link{survey_to_data_frame}()},
\code{\link{survey_to_datatable}()},
\code{\link{survey_to_tibble}()}
}
\concept{survey-objects}
\keyword{survey}
