% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recipes.R
\name{get_recipe}
\alias{get_recipe}
\title{Get recipe from repository or API}
\usage{
get_recipe(
  svy_type = NULL,
  svy_edition = NULL,
  topic = NULL,
  allowMultiple = TRUE
)
}
\arguments{
\item{svy_type}{String specifying the survey type. Examples:
"ech", "eaii", "eai", "eph"}

\item{svy_edition}{String specifying the survey edition.
Supported formats: "YYYY", "YYYYMM", "YYYY-YYYY"}

\item{topic}{String specifying the recipe topic. Examples:
"labor_market", "poverty", "income", "demographics"}

\item{allowMultiple}{Logical indicating whether
multiple recipes are allowed.
If FALSE and multiple matches exist, returns the most recent one}
}
\value{
\code{Recipe} object or list of \code{Recipe} objects according to the
specified criteria and the value of \code{allowMultiple}
}
\description{
This function retrieves data transformation recipes from the metasurvey
repository or API, based on specific criteria such as survey type, edition,
and topic. It is the primary way to access predefined and community-validated
recipes.
}
\details{
This function is essential for:
\itemize{
\item Accessing official recipes: Get validated and maintained recipes
by specialized teams
\item Reproducibility: Ensure different users apply the same standard
transformations
\item Automation: Integrate recipes into automatic pipelines
\item Collaboration: Share methodologies between teams and organizations
\item Versioning: Access different recipe versions according to edition
}

The function queries the metasurvey API to retrieve recipes. \strong{Internet
connection is required}. If the API is unavailable or you need to work
offline:

\strong{Working Offline:}
\itemize{
\item Don't call \code{get_recipe()} - work directly with steps
\item Set \code{options(metasurvey.skip_recipes = TRUE)}
to disable API calls
\item Load recipes from local files using \code{read_recipe()}
\item Create custom recipes with \code{recipe()}
}

Search criteria are combined with AND operator, so all specified criteria
must match for a recipe to be returned.
}
\examples{
\dontrun{
# Get specific recipe for ECH 2023
ech_recipe <- get_recipe(
  svy_type = "ech",
  svy_edition = "2023"
)

# Recipe for specific topic
labor_recipe <- get_recipe(
  svy_type = "ech",
  svy_edition = "2023",
  topic = "labor_market"
)

# Allow multiple recipes
available_recipes <- get_recipe(
  svy_type = "eaii",
  svy_edition = "2019-2021",
  allowMultiple = TRUE
)

# Use recipe in load_survey
ech_with_recipe <- load_survey(
  path = "ech_2023.dta",
  svy_type = "ech",
  svy_edition = "2023",
  recipes = get_recipe("ech", "2023"),
  bake = TRUE
)

# Working offline - don't use recipes
ech_offline <- load_survey(
  path = "ech_2023.dta",
  svy_type = "ech",
  svy_edition = "2023",
  svy_weight = add_weight(annual = "PESOANO")
)

# Disable recipe API globally
options(metasurvey.skip_recipes = TRUE)
# Now get_recipe() will return NULL with a warning

# For year ranges
panel_recipe <- get_recipe(
  svy_type = "ech_panel",
  svy_edition = "2020-2023"
)
}

}
\seealso{
\code{\link{recipe}} to create custom recipes
\code{\link{save_recipe}} to save recipes locally
\code{\link{read_recipe}} to read recipes from file
\code{\link{publish_recipe}} to publish recipes to the repository
\code{\link{load_survey}} where recipes are used

Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
\keyword{utils}
