% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecipeWorkflow.R
\name{read_workflow}
\alias{read_workflow}
\title{Read a RecipeWorkflow from a JSON file}
\usage{
read_workflow(file)
}
\arguments{
\item{file}{Character file path}
}
\value{
A RecipeWorkflow object
}
\description{
Read a RecipeWorkflow from a JSON file
}
\examples{
wf <- RecipeWorkflow$new(
  name = "Example", description = "Test",
  survey_type = "ech", edition = "2023",
  recipe_ids = "r_001", estimation_type = "svymean"
)
f <- tempfile(fileext = ".json")
save_workflow(wf, f)
wf2 <- read_workflow(f)
}
\seealso{
Other workflows: 
\code{\link{RecipeWorkflow-class}},
\code{\link{evaluate_cv}()},
\code{\link{print.RecipeWorkflow}()},
\code{\link{publish_workflow}()},
\code{\link{reproduce_workflow}()},
\code{\link{save_workflow}()},
\code{\link{workflow}()},
\code{\link{workflow_from_list}()},
\code{\link{workflow_table}()}
}
\concept{workflows}
\keyword{workflow}
