% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{recipe_user}
\alias{recipe_user}
\title{Create a recipe user}
\usage{
recipe_user(
  name,
  type = "individual",
  email = NULL,
  affiliation = NULL,
  institution = NULL,
  url = NULL,
  verified = FALSE
)
}
\arguments{
\item{name}{Character. User or institution name.}

\item{type}{Character. One of \code{"individual"} (default),
\code{"institutional_member"}, or \code{"institution"}.}

\item{email}{Character or \code{NULL} (default \code{NULL}). Email address.}

\item{affiliation}{Character or \code{NULL} (default \code{NULL}). Organizational affiliation.}

\item{institution}{RecipeUser object or character institution name.
Required for \code{"institutional_member"} type. If a string is provided,
it creates an institution user with that name
automatically.}

\item{url}{Character or \code{NULL} (default \code{NULL}). Institution URL.}

\item{verified}{Logical (default \code{FALSE}). Whether the account is verified.}
}
\value{
A \code{\link{RecipeUser}} object.
}
\description{
Creates a \code{\link{RecipeUser}} object with a simple
functional interface.
}
\examples{
# Individual user
user <- recipe_user("Juan Perez", email = "juan@example.com")

# Institution
inst <- recipe_user(
  "Instituto de Economia",
  type = "institution", verified = TRUE
)

# Member linked to institution
member <- recipe_user(
  "Maria",
  type = "institutional_member",
  institution = inst
)

# Member with institution name shortcut
member2 <- recipe_user(
  "Pedro",
  type = "institutional_member",
  institution = "IECON"
)

}
\seealso{
\code{\link{RecipeUser}},
\code{\link{set_user_info}},
\code{\link{certify_recipe}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
