% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_matW.R
\name{kernel_matW}
\alias{kernel_matW}
\title{kernel_matW
A function that returns a sparse weight matrix based computed with a specified
kernel (gauss,bisq,tcub,epane,rectangle,triangle) considering coordinates
provides in S and a given bandwidth. If NN<nrow(S) only NN firts neighbours are considered.
If Type!='GD' then S should have additional columns and several
kernels and bandwidths should be be specified by the user.}
\usage{
kernel_matW(H,kernels,coords,NN,TP=NULL,Type='GD',adaptive=FALSE,
diagnull=TRUE,alpha=1,dists=NULL,indexG=NULL,extrapol=FALSE,QP=NULL,K=0)
}
\arguments{
\item{H}{A vector of bandwidths}

\item{kernels}{A vector of kernel types}

\item{coords}{A matrix with  variables used in kernel (reference)}

\item{NN}{Number of spatial Neighbours for kernels computations}

\item{TP}{A vector with index of target points}

\item{Type}{Type of Genelarized kernel product ('GD' only spatial,'GDC'
spatial + a categorical variable,'GDX' spatial + a continuous variable,
'GDT' spatial + a time index, and other combinations 'GDXXC','GDTX',...)}

\item{adaptive}{A vector of boolean to choose adaptive version for each kernel}

\item{diagnull}{Zero on diagonal, default FALSE}

\item{alpha}{TO BE DOCUMENTED}

\item{dists}{TO BE DOCUMENTED}

\item{indexG}{TO BE DOCUMENTED}

\item{extrapol}{TO BE DOCUMENTED}

\item{QP}{A matrix with  variables used in kernel (neighbors), default NULL (if NULL coord_j=coord_i)}

\item{K}{TO BE DOCUMENTED}
}
\value{
A sparse Matrix of weights (dgCMatrix).
}
\description{
kernel_matW
A function that returns a sparse weight matrix based computed with a specified
kernel (gauss,bisq,tcub,epane,rectangle,triangle) considering coordinates
provides in S and a given bandwidth. If NN<nrow(S) only NN firts neighbours are considered.
If Type!='GD' then S should have additional columns and several
kernels and bandwidths should be be specified by the user.
}
\examples{
\donttest{
 library(mgwrsar)
 ## loading data example
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
 ## Creating a spatial weight matrix (sparce dgCMatrix) of 4 nearest neighbors with 0 in diagonal
 W=kernel_matW(H=4,kernels='rectangle',coords=coords,NN=4,adaptive=TRUE,diagnull=TRUE)
}
}
