% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia.R
\name{mia}
\alias{mia}
\title{MIA Method}
\usage{
mia(
  data,
  X_names,
  X_values_1,
  X_values_2 = NULL,
  contrast_type,
  Y_model,
  Y_type,
  W_model,
  W_type,
  n_mc = 10000,
  return_simulated_data = FALSE
)
}
\arguments{
\item{data}{Data frame containing the observed data.}

\item{X_names}{Vector of character strings specifying the name(s) of the predictor variable(s) \eqn{X}.}

\item{X_values_1}{Numeric vector specifying the value of the predictor variable(s) \eqn{X}, i.e. \eqn{x_1} in \eqn{\mu_{\text{MIA}}(x_1)}.}

\item{X_values_2}{(Optional) Numeric vector specifying an additional value of the predictor variable(s) \eqn{X}, i.e. \eqn{x_2} in \eqn{\mu_{\text{MIA}}(x_2)}.}

\item{contrast_type}{(Optional) Character string specifying the type of contrast to use when comparing \eqn{\mu_{\text{MIA}}(x_1)} and \eqn{\mu_{\text{MIA}}(x_2)}. Options are \code{"difference"}, \code{"ratio"}, and \code{"none"}.}

\item{Y_model}{Formula for the outcome model.}

\item{Y_type}{(Optional) Character string specifying the "type" of the outcome variable. Options are \code{"binary"} and \code{"continuous"}. If this is not supplied, the type will be inferred from the corresponding column in \code{data}.}

\item{W_model}{Formula for the auxiliary variable model. If the auxiliary variable is multivariate, this argument should be a list of model formulas, one for each component. The components will be simulated in the order they appear in the list.}

\item{W_type}{(Optional) Vector of character strings specifying the "type" of each auxiliary variable. Options are \code{"binary"}, \code{"categorical"}, and \code{"normal"}. If this is not supplied, the type will be inferred from the corresponding column in \code{data}.}

\item{n_mc}{Integer specifying the number of Monte Carlo samples to use.}

\item{return_simulated_data}{Logical scalar indicating whether to return the simulated data set(s) containing the predictors and simulated auxiliary variable. Setting this argument to \code{TRUE} can substantially increase the size of the returned object, particularly when \code{n_mc} is large. The default is \code{FALSE}.}
}
\value{
An object of class "mia". This object is a list with the following elements:
\item{mean_est_1}{conditional outcome mean estimate under \code{X_values_1}}
\item{mean_est_2}{conditional outcome mean estimate under \code{X_values_2}}
\item{contrast_est}{contrast of conditional outcome mean estimates between \code{X_values_1} and \code{X_values_2}}
\item{fit_W}{a list of fitted model(s) for W}
\item{fit_Y}{fitted model for Y}
\item{simulated_data}{a list, where the first element is the simulated data set under \code{X_values_1} and the second element is the simulated data set under \code{X_values_2}. The simulated data sets contain the predictors and simulated auxiliary variable. This element is set to \code{NULL} unless \code{return_simulated_data} is set to \code{TRUE}.}
\item{...}{additional elements}
}
\description{
This function implements the marginalization over incomplete auxiliaries (MIA) method. For an outcome variable \eqn{Y}, predictor variable \eqn{X}, and auxiliary variable \eqn{W}, this function estimates the conditional outcome mean identified by
\deqn{
\mu_{\text{MIA}}(x) = \int_{w} E [ Y | X=x, W=w, M=1 ] p( w | X=x, R_W = R_X = 1 ) dw.
}
where \eqn{R_W} and \eqn{R_X} are indicators of non-missing values of \eqn{W} and \eqn{X}, respectively, and \eqn{M} is an indicator of a complete case pattern (i.e., \eqn{Y}, \eqn{X}, and \eqn{W} are non-missing).
The function supports estimating the identifying functionals of \eqn{\mu_{\text{MIA}}(x_1)} and \eqn{\mu_{\text{MIA}}(x_2)} as well as contrasts between them (differences, ratios).
}
\details{
\strong{Estimation algorithm:}

\emph{Step 1:} One fits a model for the conditional outcome mean \eqn{E [ Y | X=x, W=w, M=1 ]} and the conditional density of the auxiliary variables \eqn{p( w | X=x, R_W = R_X = 1 )}. When \eqn{W} is multivariate, i.e., \eqn{W = (W_1, \dots, W_p)^\top}, one uses the decomposition
\deqn{p( w | X=x, R_W = R_X = 1 ) = \prod_{j = 1}^p p( w_j | X=x, w_1, \dots, w_{j-1}, R_W = R_X = 1 )}
and fits models for the components \eqn{p( w_j | X=x, w_1, \dots, w_{j-1}, R_W = R_X = 1 )}.

\emph{Step 2:} Monte Carlo integration is used to compute the integral in the identifying functional for \eqn{\mu_{\text{MIA}}(x)} based on the fitted models in the first step. More specifically, for iteration \eqn{i}, the following algorithm is performed. The value of \eqn{W} is first simulated from its estimated conditional distribution. When \eqn{W} is multivariate, the components of \eqn{W} are simulated sequentially from their fitted models. That is, \eqn{W_1} is simulated conditional on \eqn{x}, \eqn{W_2} is simulated conditional on \eqn{x, W_1}, and so on. Then, the mean of \eqn{Y} is estimated conditional on \eqn{x, W}. Finally, the average of the estimated means (across all iterations \eqn{i}) is taken as the estimate of \eqn{\mu_{\text{MIA}}(x)}.
}
\examples{
set.seed(1234)
mia(data = dat.sim,
    X_names = c("X1", "X2"),
    X_values_1 = c(0, 1), X_values_2 = c(0, 0),
    Y_model = Y ~ W + X1 + X2, W_model = W ~ X1 + X2)


}
\seealso{
\code{\link{print.mia}}, \code{\link{get_CI}}
}
