% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth.R
\name{gsynth.bin_map}
\alias{gsynth.bin_map}
\title{Create a bin mapping from value-based merge specifications}
\usage{
gsynth.bin_map(breaks, merge_ranges = NULL)
}
\arguments{
\item{breaks}{Numeric vector of bin boundaries (same as used in
\code{\link{gsynth.train}})}

\item{merge_ranges}{List of merge specifications. Each specification is a
     named list with:
\describe{
  \item{from}{Numeric vector of length 2 \code{c(min, max)} defining the
        source value range to merge. Use \code{-Inf} or \code{Inf} for
        open-ended ranges. Can also be a single number (shorthand for
        \code{c(value, Inf)}).}
  \item{to}{Numeric vector of length 2 \code{c(min, max)} defining the
        target bin that source bins should map to. Must match an existing
        bin defined by \code{breaks}.}
}}
}
\value{
A named vector (bin_map) compatible with \code{bin_map} parameter
        in \code{\link{gsynth.train}}. The names are source bin indices
        (1-based), and values are target bin indices (1-based).
}
\description{
Converts value-based bin merge specifications into a bin_map named vector
that can be used with \code{\link{gsynth.train}}. This allows you to
specify merges using actual track values rather than bin indices.
}
\examples{
# Define breaks for GC content [0, 1] in 0.025 increments
breaks <- seq(0, 1, 0.025)

# Merge all GC content above 70\% (0.7) into the bin (0.675, 0.7]
bin_map <- gsynth.bin_map(
    breaks = breaks,
    merge_ranges = list(
        list(from = 0.7, to = c(0.675, 0.7))
    )
)

# Multiple merges: merge low GC (< 0.3) and high GC (> 0.7) into middle bins
bin_map2 <- gsynth.bin_map(
    breaks = breaks,
    merge_ranges = list(
        list(from = c(-Inf, 0.3), to = c(0.4, 0.425)), # low GC -> (0.4, 0.425]
        list(from = 0.7, to = c(0.675, 0.7)) # high GC -> (0.675, 0.7]
    )
)

}
\seealso{
\code{\link{gsynth.train}}
}
